% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_cheem_lists.r
\name{cheem_ls}
\alias{cheem_ls}
\title{Preprocessing for use in shiny app}
\usage{
cheem_ls(
  x,
  y = NULL,
  attr_df,
  pred = NULL,
  class = NULL,
  basis_type = c("pca", "olda"),
  label = "label",
  verbose = getOption("verbose")
)
}
\arguments{
\item{x}{The explanatory variables of the model.}

\item{y}{The target variable of the model.}

\item{attr_df}{A data frame or matrix of (n, p) local explanation
attributions.}

\item{pred}{A (n, 1) vector, the predictions from the associated model.}

\item{class}{Optional, (n, 1) vector, a variable to group points by.
This can be the same as or different from \code{y}, the target variable.}

\item{basis_type}{The type of basis used to approximate the data and
attribution space from. Defaults to "pca".
Expects "pca" or "olda" (requires \code{class}).}

\item{label}{Optionally provide a character label to store reminder
text for the type of model and local explanation used.
Defaults to "label".}

\item{verbose}{Logical, if start time and run duration should be printed.
Defaults to getOption("verbose").}
}
\value{
A list of data.frames needed for the \code{shiny} application.
}
\description{
Performs the preprocessing steps needs to supply the plot functions
\code{global_view()} and \code{radial_cheem_tour()} used in the shiny app.
}
\examples{
library(cheem)

## Classification setup
X    <- spinifex::penguins_na.rm[, 1:4]
Y    <- spinifex::penguins_na.rm$species
clas <- spinifex::penguins_na.rm$species

## Cheem
peng_chm <- cheem_ls(X, Y, penguin_xgb_shap, penguin_xgb_pred, clas,
                     label = "Penguins, xgb, shapviz")

## Save for use with shiny app (expects an rds file)
if(FALSE){ ## Don't accidentally save.
  saveRDS(peng_chm, "./peng_xgb_shapviz.rds")
  run_app() ## Select the saved rds file from the data dropdown.
}

## Cheem visuals
if(interactive()){
  prim <- 1
  comp <- 2
  global_view(peng_chm, primary_obs = prim, comparison_obs = comp)
  bas <- sug_basis(peng_xgb_shap, prim, comp)
  mv  <- sug_manip_var(peng_xgb_shap, primary_obs = 1, comparison_obs = 2)
  ggt <- radial_cheem_tour(peng_chm, basis = bas, manip_var = mv)
  animate_plotly(ggt)
}

## Regression example
library(cheem)

## Regression setup
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Cheem list
ames_rf_chm <- cheem_ls(X, Y, ames_rf_shap, ames_rf_pred, clas,
                        label = "North Ames, RF, treeshap")

## Save for use with shiny app (expects an rds file)
if(FALSE){ ## Don't accidentally save.
  saveRDS(ames_rf_chm, "./NAmes_rf_tshap.rds")
  run_app() ## Select the saved rds file from the data drop down.
}

## Cheem visuals
if(interactive()){
  prim <- 1
  comp <- 2
  global_view(ames_rf_chm, primary_obs = prim, comparison_obs = comp)
  bas <- sug_basis(ames_rf_shap, prim, comp)
  mv  <- sug_manip_var(ames_rf_shap, primary_obs = 1, comparison_obs = 2)
  ggt <- radial_cheem_tour(ames_rf_chm, basis = bas, manip_var = mv)
  animate_plotly(ggt)
}
}
\seealso{
\code{\link[=global_view]{global_view()}} \code{\link[=radial_cheem_tour]{radial_cheem_tour()}} \code{\link[=radial_cheem_tour]{radial_cheem_tour()}}

Other cheem preprocessing: 
\code{\link{subset_cheem}()}
}
\concept{cheem preprocessing}
