% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_visualization.r
\name{radial_cheem_tour}
\alias{radial_cheem_tour}
\title{Cheem tour; 1D manual tour on the selected attribution}
\usage{
radial_cheem_tour(
  cheem_ls,
  basis,
  manip_var,
  primary_obs = NULL,
  comparison_obs = NULL,
  do_add_pcp_segments = TRUE,
  pcp_shape = c(3, 142, 124),
  angle = 0.15,
  row_index = NULL,
  inc_var_nms = NULL,
  do_center_frame = TRUE,
  do_add_residual = FALSE
)
}
\arguments{
\item{cheem_ls}{A return from \code{cheem_ls()}, a list of data frames.}

\item{basis}{A 1D projection basis, typically a return of
\code{sug_basis()}.}

\item{manip_var}{The , \emph{number} of the manipulation variable.}

\item{primary_obs}{The rownumber of the primary observation. Its local
attribution becomes the 1d projection basis, and the point it highlighted
as a dashed line. Defaults to NULL, no primary observation highlighted.}

\item{comparison_obs}{The rownumber of the comparison observation. Point
is highlighted as a dotted line. Defaults to NULL,
no comparison observation highlighted.}

\item{do_add_pcp_segments}{Logical, whether or not to add parallel coordinate
line segments to the basis display.}

\item{pcp_shape}{The number of the shape character to add. Expects
3, 142, or 124, '+', '|' in \code{plotly}, and '|' in \code{gganimate}, respectively.
Defaults to 3, '+' in either output.}

\item{angle}{The step size between interpolated frames, in radians.
Defaults to .15.}

\item{row_index}{Numeric index of selected observations.
Defaults to TRUE; 1:n.}

\item{inc_var_nms}{A vector of the names of the variables to include in the
projection.}

\item{do_center_frame}{Whether or not to scale by standard deviations away
from the mean within each frame or not.
Defaults to TRUE, helping to keep the animation centered.}

\item{do_add_residual}{Whether of not to add a facet with a fixed y on
residual. Doing so may cause issues with animation. Defaults to FALSE.}
}
\value{
ggtour (\code{ggplot2} object with frame info) animation frames of a
radial tour manipulating the contribution of a selected tour. Animated with
\verb{spinifex::animate_*} functions.
}
\description{
Create a linked \code{plotly}of the global data-
and attribution- spaces. Typically consumed directly by shiny app.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## radial_cheem_tour()
ames_rf_chm <- cheem_ls(X, Y, ames_rf_shap, ames_rf_pred, clas,
                        label = "North Ames, RF, SHAP")
bas <- sug_basis(ames_rf_shap, 1)
mv  <- sug_manip_var(ames_rf_shap, 1, 2)
ggt <- radial_cheem_tour(ames_rf_chm, basis = bas, manip_var = mv)
if(interactive()){
  ## As a plotly html widget
  spinifex::animate_plotly(ggt)
  
  ## As a gganimation
  spinifex::animate_gganimate(ggt, render = gganimate::av_renderer())
}
## Also used in: ?run_app()
}
\seealso{
\code{\link[=run_app]{run_app()}}

Other cheem consumers: 
\code{\link{global_view_legwork}()},
\code{\link{global_view}()},
\code{\link{run_app}()}
}
\concept{cheem consumers}
