% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_indicators.R
\name{chiquad_red}
\alias{chiquad_red}
\title{Reduced chi-squared}
\usage{
chiquad_red(fit)
}
\arguments{
\item{fit}{\code{nls} object with weighted fit}
}
\value{
Returns the reduced chi-squared value
}
\description{
Function that returns the reduced chi-squared (\eqn{\chi^2_{red}=\chi^2/df},
where \eqn{df} are the degrees of freedom) value for
a non-linear regression model (\code{nls} object). Reduced-chi squared is a
goodness-of-fit measure. Values close to 1 indicates a good fit, while
values \eqn{>>1} indicate poor fit and values \eqn{<1} indicate
over-fitting.
The function is calculated only with non-linear regression weighted on
experimental error.
}
\examples{
x <- c(1, 2, 3, 4, 5)
y <- c(1.2, 3.9, 8.6, 17.4, 26)
er <- c(0.5, 0.8, 0.5, 1.9, 1.2)
fit1 <- nls(y ~ k * x^2,
  data = list(x = x, y = y),
  start = list(k = 1),
  weights = 1 / er^2
)
chiquad_red(fit1)

fit2 <- nls(y ~ k * x^3,
  data = list(x = x, y = y),
  start = list(k = 1),
  weights = 1 / er^2
)
chiquad_red(fit2)
}
\references{
Philip R. Bevington,
D. Keith Robinson,
J. Morris Blair,
A. John Mallinckrodt,
Susan McKay (1993).
\emph{Data Reduction and Error Analysis for the Physical Sciences}
}
\seealso{
\code{\link[stats:Chisquare]{stats::dchisq()}} for chi-squared distribution; \code{\link[stats:AIC]{stats::AIC()}},
\code{\link[stats:AIC]{stats::BIC()}}, \code{\link[stats:sigma]{stats::sigma()}} (for RMSE), \code{\link[=AICC]{AICC()}} for other
goodness-of-fit
indicators. \code{\link[=goodness_of_fit]{goodness_of_fit()}}
}
