% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aet10.R
\docType{data}
\name{aet10_main}
\alias{aet10_main}
\alias{aet10_pre}
\alias{aet10_post}
\alias{aet10}
\title{\code{AET10} Table 1 (Default) Most Common (xx\%) Adverse Events Preferred Terms Table 1.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
aet10_main(adam_db, arm_var = "ACTARM", lbl_overall = NULL, ...)

aet10_pre(adam_db, ...)

aet10_post(tlg, atleast = 0.05, ...)

aet10
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{atleast}{given cut-off in numeric format, default is \code{0.05}}
}
\value{
the main function returns an \code{rtables} object

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{AET10} table Include Adverse Events occurring with user-specified threshold X\% in at least
one of the treatment groups. Standard table summarized by preferred term (PT).
Order the data by total column frequency from most to least frequently reported PT (regardless of SOC).
}
\details{
\itemize{
\item Numbers represent absolute numbers of subject and fraction of \code{N}, or absolute number of event when specified.
\item Remove zero-count rows unless overridden with \code{prune_0 = FALSE}.
\item Split columns by arm.
\item Does not include a total column by default.
\item Sort Dictionary-Derived Code (\code{AEDECOD}) by highest overall frequencies.
\item Missing values in \code{AEDECOD} are labeled by \verb{No Coding Available}.
}
}
\section{Functions}{
\itemize{
\item \code{aet10_main()}: Main TLG function

\item \code{aet10_pre()}: Preprocessing

\item \code{aet10_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adae} table with the columns \code{"AEDECOD"}.
}
}
\examples{
run(aet10, syn_data)
}
\keyword{datasets}
