% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fstg01.R
\docType{data}
\name{fstg01_main}
\alias{fstg01_main}
\alias{fstg01_pre}
\alias{fstg01}
\title{\code{FSTG01} Subgroup Analysis of Best Overall Response.}
\format{
An object of class \code{chevron_g} of length 1.
}
\usage{
fstg01_main(
  adam_db,
  dataset = "adrs",
  arm_var = "ARM",
  rsp_var = "IS_RSP",
  subgroups = c("SEX", "AGEGR1", "RACE"),
  strata_var = NULL,
  stat_var = c("n_tot", "n", "n_rsp", "prop", "or", "ci"),
  ...
)

fstg01_pre(adam_db, ...)

fstg01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{dataset}{(\code{string}) the name of a table in the \code{adam_db} object.}

\item{arm_var}{(\code{string}) the arm variable name used for group splitting.}

\item{rsp_var}{(\code{string}) the response variable name to flag whether each subject is a binary response or not.}

\item{subgroups}{(\code{character}) the subgroups variable name to list baseline risk factors.}

\item{strata_var}{(\code{character}) required if stratified analysis is performed.}

\item{stat_var}{(\code{character}) the names of statistics to be reported in \code{tabulate_rsp_subgroups}.}

\item{...}{Further arguments passed to \code{g_forest} and \code{extract_rsp_subgroups} (a wrapper for
\code{h_odds_ratio_subgroups_df} and \code{h_proportion_subgroups_df}). For details, see the documentation in \code{tern}.
Commonly used arguments include \code{col_symbol_size}, \code{col}, \code{vline}, \code{groups_lists}, \code{conf_level},
\code{method}, \code{label_all}, etc.}
}
\value{
the main function returns a \code{grob} object.

a \code{gTree} object.

the preprocessing function returns a \code{list} of \code{data.frame}.
}
\description{
The template produces the subgroup analysis of best overall response graphic.
}
\details{
\itemize{
\item No overall value.
\item Keep zero count rows by default.
}
}
\section{Functions}{
\itemize{
\item \code{fstg01_main()}: Main TLG Function

\item \code{fstg01_pre()}: Preprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain the table specified by \code{dataset} with \code{"PARAMCD"}, \code{"ARM"},
\code{"AVALC"}, and the columns specified by \code{subgroups} which is denoted as
\code{c("SEX", "AGEGR1", "RACE")} by default.
\item If the plot is too large to be rendered in the output, please provide \code{gp}, \code{width_row_names},
\code{width_columns} and \code{width_forest} manually to make it fit. See \code{tern::g_forest} for more details.
}
}
\examples{
library(dplyr)
library(dunlin)

proc_data <- log_filter(
  syn_data,
  PARAMCD == "BESRSPI" & ARM \%in\% c("A: Drug X", "B: Placebo"), "adrs"
)
run(fstg01, proc_data,
  subgroups = c("SEX", "AGEGR1", "RACE"),
  conf_level = 0.90, dataset = "adrs"
)
}
\keyword{datasets}
