% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdsvals.r
\name{sds_2d}
\alias{sds_2d}
\title{Calculate SDS Values for 2-dimensional matrix of covariates}
\usage{
sds_2d(value, age, x2, sex, item, ref, type = "SDS", male = "male",
  female = "female")
}
\arguments{
\item{value}{vector of measurement values}

\item{age}{vector of age values}

\item{x2}{second vector of covariates}

\item{sex}{vector of sex}

\item{item}{name of the item e.g. "height"}

\item{ref}{RefGroup object}

\item{type}{"SDS" or "perc"}

\item{male}{coding of sex for male}

\item{female}{coding of sex for male}
}
\value{
vector containing SDS or percentile values
}
\description{
Calculate SDS values for 2-dimensional matrix of covariates
}
\details{
The function takes a vector of measurement values, and of age and a
second covariate (like age and height for blood pressure) of sex
and a RefGroup object as arguments. It calculates the sds or percentile
values. This function is beta.

the function searches for the nearest given point in the reference grid.
From there, the SDS/percentile value will be calculated. Different from \code{\link{sds}},
no interpolation will be applied. The procedure is according to Neuhauser et al. Blood
Pressure Percentiles by Age and Height from Nonoverweight Children and Adolescents
in Germany. 2011.
}
\author{
Mandy Vogel
}
