% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-equivalent.R
\name{chk_equivalent}
\alias{chk_equivalent}
\alias{vld_equivalent}
\title{Check Equivalent}
\usage{
chk_equivalent(x, y, tolerance = sqrt(.Machine$double.eps), x_name = NULL)

vld_equivalent(x, y, tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{The object to check.}

\item{y}{An object to check against.}

\item{tolerance}{A non-negative numeric scalar.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is equivalent (equal ignoring attributes) to y using

\code{vld_true(all.equal(x, y, tolerance, check.attributes = FALSE))}
}
\section{Functions}{
\itemize{
\item \code{vld_equivalent}: Validate Equivalent
}}

\examples{

# chk_equivalent
chk_equivalent(1, 1.00000001)
try(chk_equivalent(1, 1.0000001))
chk_equivalent(1, 1L)
chk_equivalent(c(x = 1), c(y = 1))

vld_equivalent(c(x = 1), c(y = 1L))
}
\seealso{
Other chk_equals: 
\code{\link{chk_equal}()},
\code{\link{chk_identical}()}
}
\concept{chk_equals}
