% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-true.R
\name{chk_true}
\alias{chk_true}
\alias{vld_true}
\title{Check TRUE}
\usage{
chk_true(x, x_name = NULL)

vld_true(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} functions throw an informative error if the test fails.

The \code{vld_} functions return a flag indicating whether the test was met.
}
\description{
Checks if TRUE using

\code{is.logical(x) && length(x) == 1L && !anyNA(x) && x}
}
\section{Functions}{
\itemize{
\item \code{vld_true}: Validate TRUE
}}

\examples{

# chk_true
chk_true(TRUE)
try(chk_true(1))

# vld_true
vld_true(TRUE)
vld_true(FALSE)
vld_true(NA)
vld_true(0)
vld_true(c(TRUE, TRUE))
}
\seealso{
Other chk_logical: 
\code{\link{chk_false}()},
\code{\link{chk_flag}()},
\code{\link{chk_lgl}()}
}
\concept{chk_logical}
