% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_chkpt_draws.R
\name{combine_chkpt_draws}
\alias{combine_chkpt_draws}
\title{Combine Checkpoint Draws}
\usage{
combine_chkpt_draws(object, ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit} or \code{chkpt_stan}.}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{draws_array}.
}
\description{
Combine Checkpoint Draws
}
\examples{
 
\dontrun{  
path <- create_folder(folder_name = "chkpt_folder_fit1")

stan_code <- "
data {
 int<lower=0> n;
  real y[n];
  real<lower=0> sigma[n];
}
parameters {
  real mu;
  real<lower=0> tau;
  vector[n] eta;
}
transformed parameters {
  vector[n] theta;
  theta = mu + tau * eta;
}
model {
  target += normal_lpdf(eta | 0, 1);
  target += normal_lpdf(y | theta, sigma);
}
"

stan_data <- schools.data <- list(
  n = 8,
  y = c(28,  8, -3,  7, -1,  1, 18, 12),
  sigma = c(15, 10, 16, 11,  9, 11, 10, 18)
)

fit2 <- chkpt_stan(model_code = stan_code,
                   data = stan_data,
                   iter_warmup = 1000,
                   iter_sampling = 1000,
                   iter_per_chkpt = 250,
                   path = path)

draws <- combine_chkpt_draws(object = fit2)

draws
}
}
