% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_folder.R
\name{create_folder}
\alias{create_folder}
\title{Create Folder for Checkpointing}
\usage{
create_folder(folder_name = "cp_folder", path = NULL)
}
\arguments{
\item{folder_name}{Character string. Desired name for the "parent"
folder (defaults to \code{checkpoint}).}

\item{path}{Character string, when specified. Defaults to \code{NULL},
which then makes the folder in the working directory.}
}
\value{
No return value, and instead creates a directory with
folders that will contain the checkpointing samples and other
information.
}
\description{
Create the folder for checkingpointing, which
will "house" additional folders for the \code{.stan}
model, checkpointing information, and draws from the
posterior distribution.
}
\note{
This creates a directory with four folders:

\itemize{

\item \strong{cmd_fit}: The cmdstanr fittted models (one for each checkpoint).

\item \strong{cp_info}: Mass matrix, step size, and initial values for
next checkpoint (last iteration from previous checkpoint).

\item \strong{cp_samples}: Samples from the posterior distribution
(post warmup)

\item \strong{stan_model}: Complied \strong{Stan} model

}
}
\examples{
path <- create_folder(folder_name = "cp_folder")

# remove folder
unlink("cp_folder", recursive = TRUE)
}
