% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{kernelfunction}
\alias{kernelfunction}
\title{Kernel functions}
\usage{
kernelfunction(
  d,
  bw,
  kernel = c("uniform", "quartic", "triweight", "epanechnikov")
)
}
\arguments{
\item{d}{Distance}

\item{bw}{Bandwidth of a kernel}

\item{kernel}{Kernel type. One of
\code{"uniform"}, \code{"quartic"}, \code{"triweight"}, and \code{"epanechnikov"}}
}
\value{
numeric. Kernel weights.
}
\description{
Kernel functions
}
\examples{
v_dist <- c(1, 10, 100, 25, 50, 0.1)
bw_dist1 <- 1
bw_dist2 <- 10
kernelfunction(v_dist, bw_dist1, "uniform")
kernelfunction(v_dist, bw_dist1, "quartic")
kernelfunction(v_dist, bw_dist1, "triweight")
kernelfunction(v_dist, bw_dist1, "epanechnikov")
kernelfunction(v_dist, bw_dist2, "uniform")
kernelfunction(v_dist, bw_dist2, "quartic")
kernelfunction(v_dist, bw_dist2, "triweight")
kernelfunction(v_dist, bw_dist2, "epanechnikov")
}
\references{
https://github.com/JanCaha/SpatialKDE
}
\seealso{
Other Macros for calculation: 
\code{\link{extract_at}()},
\code{\link{summarize_aw}()},
\code{\link{summarize_sedc}()}
}
\concept{Macros for calculation}
\keyword{internal}
