% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_callbacks.R
\name{landscape_plotter}
\alias{landscape_plotter}
\title{Plot simulation landscapes}
\usage{
landscape_plotter(
  mod,
  col = NULL,
  fps_cap = 24,
  burn_in = 0,
  transpose = TRUE,
  new_window = TRUE,
  ...
)
}
\arguments{
\item{mod}{The model being used (created by \code{link{camodel}})}

\item{col}{a set of colors (character vector) of length equal to the number of
states in the model.}

\item{fps_cap}{The maximum number of frame displayed per seconds. Simulation
will be slowed down if necessary so that plot updates will not be
more frequent than this value}

\item{burn_in}{Do not display anything before this time step has been
reached}

\item{transpose}{Set to \code{TRUE} to transpose the landscape matrix
before displaying it \code{\link[graphics]{image}}}

\item{new_window}{Controls whether the plots are displayed in a new window,
or in the default device (typically the plot panel in Rstudio)}

\item{...}{other arguments are passed to \code{\link[graphics]{image}}}
}
\value{
This function returns another function, which will be called internally 
   when simulating the model using \code{\link{run_camodel}}, and has probably 
   not much use outside of this context. The return function will display the 
   simulation and returns NULL.
}
\description{
This function creates an internal function to plot the model
  landscape during the simulation of a stochastic cellular automaton.
}
\details{
This function creates another function that is suitable for use with
  \code{\link{run_camodel}}. It allows plotting the landscape as it is being
  simulated, using the base function \code{\link[graphics]{image}}. You can set
  colors using the argument \code{col}, or tranpose the landscape before
  plotting using \code{transpose}. The resulting function must by passed to
  \code{\link{run_camodel}} as the control argument \code{custom_output_fun}.
  Typically, this function is not used by itself, but is being used when
  specifying simulation options before calling \code{\link{run_camodel}},
  see examples below.

  \code{\link[graphics]{image}} is used internally, and tends to be quite slow at
  displaying results, but if it is still too fast for your taste, you can cap the
  refresh rate at a value given by the argument \code{fps_cap}.

  It is important to note that this function will probably massively slow
  down a simulation, so this is most useful for exploratory analyses.
}
\examples{

\donttest{

# Display the psychedelic spirals of the rock-paper-scissor model as the model is
# being run
mod <- ca_library("rock-paper-scissor")
colors <- c("#fb8500", "#023047", "#8ecae6")
ctrl <- list(custom_output_every = 1,
             custom_output_fun = landscape_plotter(mod, col = colors))
init <- generate_initmat(mod, rep(1, 3)/3, nrow = 100, ncol = 178)
run_camodel(mod, init, times = seq(0, 128), control = ctrl)

# Arid vegetation model
mod <- ca_library("aridvege")
init <- generate_initmat(mod, rep(1, 3)/3, nrow = 100, ncol = 178)
colors <- c("gray80", "white", "darkgreen")
ctrl <- list(custom_output_every = 1,
             custom_output_fun = landscape_plotter(mod, col = colors, xaxt = "n",
                                                   yaxt = "n"))
run_camodel(mod, init, times = seq(0, 128), control = ctrl)

# Game of life, set plot margins to zero so that the landscape takes all
# of the plot window
mod <- ca_library("gameoflife")
init <- generate_initmat(mod, c(0.5, 0.5), nrow = 100, ncol = 178)
colors <- c("white", "black")
ctrl <- list(custom_output_every = 1,
             custom_output_fun = landscape_plotter(mod, col = colors,
                                                   mar = c(0, 0, 0, 0)))
run_camodel(mod, init, times = seq(0, 128), control = ctrl)

}

}
\seealso{
trace_plotter, run_camodel
}
