% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_rt.R
\name{correct_rt}
\alias{correct_rt}
\title{Correct retention time}
\usage{
correct_rt(
  chrom_list,
  lambdas,
  models = NULL,
  reference = "best",
  alg = c("ptw", "vpdtw"),
  what = c("models", "corrected.values"),
  init.coef = c(0, 1, 0),
  n.traces = NULL,
  n.zeros = 0,
  scale = FALSE,
  trwdth = 200,
  plot = FALSE,
  penalty = 5,
  maxshift = 50,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{chrom_list}{List of matrices containing concentration profiles.}

\item{lambdas}{Select wavelengths to use by name.}

\item{models}{List of models to warp by.}

\item{reference}{Index of the sample that is to be considered the reference
sample.}

\item{alg}{algorithm to use: parametric time warping(\code{ptw}) or variable
penalty dynamic time warping \code{vpdtw}.}

\item{what}{What to return: either the 'corrected.values' (useful for visual
inspection) or the warping 'models' (for further programmatic use).}

\item{init.coef}{Starting values for the optimization.}

\item{n.traces}{Number of traces to use.}

\item{n.zeros}{Number of zeros to add.}

\item{scale}{Logical. If true, scale chromatograms before warping.}

\item{trwdth}{width of the triangle in the WCC criterion.}

\item{plot}{Logical. Whether to plot alignment.}

\item{penalty}{Divisor for dilation calculated by \code{\link[VPdtw]{dilation}}.
Adjusts penalty for variable penalty dynamic time warping.}

\item{maxshift}{Integer. Maximum allowable shift for \code{\link[VPdtw]{VPdtw}}.}

\item{verbose}{Whether to be verbose.}

\item{\dots}{Optional arguments for the \code{\link[ptw:ptw]{ptw}} function.
The only argument that cannot be changed is \code{warp.type}: this is always
equal to \code{"global"}.}
}
\value{
A list of \code{ptw} objects or a list of warped absorbance profiles,
depending on the value of the \code{what} argument.
}
\description{
Corrects retention time differences using parametric time warping, as
implemented in \code{\link[ptw]{ptw}}, or variable penalty dynamic
time warping, as implemented in \code{\link[VPdtw]{VPdtw}}.
}
\details{
To use variable penalty dynamic time warping, the \code{VPdtw} package must
be manually installed since it's no longer available from CRAN: \code{
install.packages('VPdtw', repos='https://ethanbass.github.io/drat/')}.
}
\note{
Adapted from
\href{https://github.com/rwehrens/alsace/blob/master/R/correctRT.R}{correctRT}
function in the alsace package by Ron Wehrens.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sa_pr)
warping.models <- correct_rt(Sa_pr, what = "models", lambdas=c("210"))
warp <- correct_rt(chrom_list = Sa_pr, models = warping.models)
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Clifford, D., Stone, G., Montoliu, I., Rezzi, S., Martin, F. P., Guy, P.,
... & Kochhar, S. 2009. Alignment using variable penalty dynamic time warping.
\emph{Analytical chemistry}, \bold{81(3)}:1000-1007. \doi{10.1021/ac802041e}.
\item Clifford, D., & Stone, G. 2012. Variable Penalty Dynamic Time Warping Code
for Aligning Mass Spectrometry Chromatograms in R. \emph{Journal of
Statistical Software}, \bold{47(8)}:1-17. \doi{10.18637/jss.v047.i08}.
\item Eilers, P.H.C. 2004. Parametric Time Warping.
\emph{Anal. Chem.}, \bold{76}:404-411. \doi{10.1021/ac034800e}.
\item Wehrens, R., Bloemberg, T.G., and Eilers P.H.C. 2015. Fast
parametric time warping of peak lists. \emph{Bioinformatics},
\bold{31}:3063-3065. \doi{10.1093/bioinformatics/btv299}.
\item Wehrens, R., Carvalho, E., Fraser, P.D. 2015. Metabolite profiling in
LC–DAD using multivariate curve resolution: the alsace package for R. \emph{
Metabolomics}, \bold{11}:143-154. \doi{10.1007/s11306-014-0683-5}
}
}
\seealso{
\code{\link[ptw:ptw]{ptw}}, \code{\link{correct_peaks}},
\code{\link[VPdtw]{VPdtw}}
}
\author{
Ethan Bass
}
