% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spectrum.R
\name{plot_all_spectra}
\alias{plot_all_spectra}
\title{Plot all spectra for chosen peak.}
\usage{
plot_all_spectra(
  peak,
  peak_table,
  chrom_list,
  chrs = "all",
  plot_spectrum = TRUE,
  export_spectrum = TRUE,
  scale_spectrum = TRUE,
  overlapping = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{peak}{The name of a peak to plot (in character
format)}

\item{peak_table}{The peak table (output from \code{\link{get_peaktable}}
function)}

\item{chrom_list}{A list of profile matrices, each of the same dimensions
(timepoints x components).}

\item{chrs}{Vector of chromatograms to plot.}

\item{plot_spectrum}{Logical. If TRUE, plots the spectrum of the chosen
peak.}

\item{export_spectrum}{Logical. If TRUE, exports spectrum to console.
Defaults to FALSE.}

\item{scale_spectrum}{Logical. If TRUE, scales spectrum to unit height.}

\item{overlapping}{Logical. If TRUE, plot spectra in single plot.}

\item{verbose}{Logical. If TRUE, prints verbose output to console.}

\item{\dots}{Additional arguments to plot_spectrum.}
}
\value{
If \code{export_spectrum} is TRUE, returns the spectra as a \code{
data.frame} with wavelengths as rows and one column for each sample in the
\code{chrom_list} encoding the absorbance (or normalized absorbance, if
\code{scale_spectrum} is TRUE) at each wavelength. Otherwise, there is no
return value.
}
\description{
Plot multiple for a given peak in peak table. Wrapper for
\code{\link{plot_spectrum}}.
}
\section{Side effects}{

If \code{plot_spectrum} is TRUE, plots the spectra for the specified chromatogram
(\code{chr}) of the given \code{peak}. The spectrum is a single row
from the chromatographic matrix.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sa_warp)
pks <- get_peaks(Sa_warp, lambda="220")
pk_tab <- get_peaktable(pks)
plot_all_spectra(peak="V13", peak_table = pk_tab, overlapping=TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{plot_spectrum}}
}
\author{
Ethan Bass
}
