% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplots.R
\name{make_barplot}
\alias{make_barplot}
\title{Create a bar plot from a data frame through ggplotly}
\usage{
make_barplot(
  dt,
  bars,
  value = NULL,
  break_bars_by = NULL,
  horizontal = FALSE,
  sort_by_value = FALSE,
  sort_decreasing = TRUE,
  ggtheme = "minimal",
  x_axis_label = NULL,
  y_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = "plasma"
)
}
\arguments{
\item{dt}{data.frame containing the data to plot.}

\item{bars}{Name of the column containing the different groups.}

\item{value}{Name of the columns to use as value on the y axis of the plot. If NULL (default), counts will be used.}

\item{break_bars_by}{Name of the categorical variable used to break each bar}

\item{horizontal}{Plot the bars horizontally. Default is FALSE}

\item{sort_by_value}{Sort the bars by value. Default is FALSE}

\item{sort_decreasing}{Sort the values decreasingly. Default is TRUE, but sort_by_value must also be TRUE.}

\item{ggtheme}{ggplot2 theme function to apply. Default is ggplot2::theme_minimal.}

\item{x_axis_label}{Label for the x axis.}

\item{y_axis_label}{Label for the y axis.}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required}
}
\value{
A plotly-ized version of a ggplot bar plot.
}
\description{
Create a bar plot from a data frame through ggplotly
}
\examples{
make_barplot(dt = iris, bars = 'Species', value = 'Sepal.Length')
make_barplot(dt = ggplot2::mpg,
             bars = 'manufacturer',
             break_bars_by = 'model',
             value = 'cty',
             horizontal = TRUE,
             sort_by_value = TRUE)
}
