% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chronochrt_label_text.R
\name{add_label_text}
\alias{add_label_text}
\title{Provide text labels for a chronological chart}
\usage{
add_label_text(data, region, year, position = 0.9, label, new = FALSE, ...)
}
\arguments{
\item{data}{An object to which labels should be added. Must not be provided
if \code{new = FALSE}.}

\item{region}{A character string or character vector with the the titles of
the sections the label(s) should be placed in.}

\item{year}{A number or a numeric vector with the year(s) at which the label
should be placed (i.e. its vertical position).}

\item{position}{A number or a numeric vector with the horizontal position(s)
of the label. See Details for explanation.}

\item{label}{A character string or character vector with the text of the
label(s).}

\item{new}{Logical operator. If \code{TRUE}, a new data set will be created.
If \code{FALSE}, the default, the input will be added to an existing data
set.}

\item{...}{Further columns to include, or additional arguments
passed to \code{\link[tibble]{tibble}} or
\code{\link[tibble]{add_row}}.}
}
\value{
A tibble with text labels ready-to-use in
  \code{\link{plot_chronochrt}}.
}
\description{
The function creates a tibble with text labels to be plotted in a
chronological chart or adds them to an an already existing tibble.
}
\details{
If the input is in the same order as the arguments, the arguments do not
need to be explicitly named. Values can be provided as one number or one
character string, if they are the same for all other data. If not, they must
be provided as vectors with equal lengths.
It is assumed that most of the labels will be located on the right side of
each column. The \code{position} of a label defines it right most end to
prevent it from running outside the plotting area. Vertically, it will be
placed centred on the \code{year} given. Text in labels can be wrapped by
inserting \code{\\n} (without blanks around it).
}
\examples{
# Create new label data set
labels <- add_label_text(region = "A",
                         year = -50,
                         position = 0.5,
                         label = "Flood",
                         new = TRUE)

# Add labels to existing data set
labels <- add_label_text(data = labels,
                         region = "B",
                         year = 50,
                         position = 0.9,
                         label = "Earthquake",
                         new = FALSE)

# They can be linked using the pipe operator \code{\%>\%}:
library(magrittr)

labels <- add_label_text(region = "A",
                         year = -50,
                         position = 0.5,
                         label = "Flood",
                         new = TRUE) \%>\%
          add_label_text(region = "B",
                         year = 50,
                         position = 0.9,
                         label = "Earthquake")
}
