% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\docType{methods}
\name{mapplot}
\alias{mapplot}
\alias{mapplot,RasterLayer-method}
\alias{mapplot,RasterStack-method}
\alias{mapplot,RasterArray-method}
\alias{mapplot,SpatialPolygonsDataFrame-method}
\alias{mapplot,SpatialPolygons-method}
\title{Wrapper function to plot maps of different classes}
\usage{
mapplot(x, ...)

\S4method{mapplot}{RasterLayer}(x, col = "gradinv", axes = FALSE,
  box = FALSE, legend = FALSE, legend.title = NULL, ...)

\S4method{mapplot}{RasterStack}(x, col = gradinv(255), ...)

\S4method{mapplot}{RasterArray}(x, col = "gradinv", rgb = FALSE,
  legend = FALSE, axes = FALSE, box = FALSE, ncol = 3,
  legend.title = NULL, plot.title = NULL, rowlabels = rownames(x),
  multi = FALSE, ask = FALSE, ...)

\S4method{mapplot}{SpatialPolygonsDataFrame}(x, col = "lightgrey", ...)

\S4method{mapplot}{SpatialPolygons}(x, col = "lightgrey", ...)
}
\arguments{
\item{x}{Object to be plotted}

\item{...}{arguments passed to class-specific methods.}

\item{col}{\code{character} Color or color scheme of the plot. See \code{?ramps} for available palettes.}

\item{axes}{\code{logical} Should axes be displayed?}

\item{box}{\code{logical} Should bounding boxes be displayed?}

\item{legend}{(\code{logical}) Triggers whether the legend of a RasterLayer would be plotted.}

\item{legend.title}{title for the legend, if legend = TRUE.}

\item{rgb}{set to \code{TRUE} to make a red-green-blue plot based on three layers or bands.}

\item{ncol}{set number of columns in a multi-plot for a single variable. For a RasterArray with multiple variables, this number is automatically set to the number of variables.}

\item{plot.title}{The title for each individual plot. Only available for a single variable at the moment.}

\item{rowlabels}{label for each row of the overall plot. Uses the rownames of the RasterArray by default. Only availble for multivariate RasterArrays.}

\item{multi}{Should the plots be printed on multiple pages?}

\item{ask}{NULL or a logical values. If multi.page = TRUE and ask = TRUE, then the user will be prompted before a new page of output is started}
}
\value{
None.
}
\description{
This function plots Raster and sp-type objects.
}
\examples{

 #single variable
	data(dems)
	mapplot(dems, ncol=4)
	
	#multiple variables
	data(clim)
	mapplot(clim, multi=TRUE, legend=TRUE)
}
