% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XArray-apply.R, R/RasterArray-base.R
\docType{data}
\name{apply}
\alias{apply}
\alias{apply,RasterArray-method}
\alias{apply,SpatialArray-method}
\title{Apply-type iterator for RasterArrays and SpatialArrays}
\format{
An object of class \code{standardGeneric} of length 1.
}
%\usage{
%apply(X, MARGIN, FUN, ...)
%
%apply
%}
\arguments{
\item{X}{an array, including matrices and RasterArrays.}

\item{MARGIN}{a vector giving the subscripts which the function will be applied over. E.g., for a matrix 1 indicates rows, 2 indicates columns, \code{c(1, 2)} indicates rows and columns. Where \code{X} has named dimnames, it can be a character vector selecting dimension names. For \code{RasterArrays} only single dimension margins are implemented. If it is \code{NULL} then the function is applied to every item.}

\item{FUN}{the function to be applied: see ‘Details’ of \code{\link[base]{apply}}.}

\item{...}{optional arguments passed to \code{FUN}.}
}
\value{
Depending on the on the output of \code{FUN}, a \code{list}, a \code{vector} or \code{RasterArray} or \code{SpatialArray} object.
}
\description{
The function implements the \code{\link[base]{apply}}-type iterators for the RasterArray class. Output values are constrained to RasterArrays, whenever possible. 
Not yet implemented for multidimensional MARGINs.
}
\examples{
# Null dimensional margin
data(coasts)
# apply function to every element manually
# memory taken by every layer
apply(coasts, MARGIN=NULL, object.size)
# double of itself
data(dems)
a<- cbind(dems, dems)
same <- apply(a, 1, sum)
}
\keyword{datasets}
