% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_probs_glm.R
\name{add_probs.glm}
\alias{add_probs.glm}
\title{Response Probabilities for Generalized Linear Models}
\usage{
\method{add_probs}{glm}(tb, fit, q, name = NULL, yhatName = "pred",
  comparison = "<", nSims = 2000, ...)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{glm}. Predictions are made with
this object.}

\item{q}{A double. A quantile of the response distribution.}

\item{name}{\code{NULL} or a string. If \code{NULL}, probabilities
automatically will be named by \code{add_probs()}, otherwise,
the probabilities will be named \code{name} in the returned
tibble}

\item{yhatName}{A string. Name of the vector of predictions.}

\item{comparison}{A character vector of length one. If
\code{comparison = "<"}, then \eqn{Pr(Y|X < q)} is
calculated. Any comparison is allowed in Poisson regression,
but only certain comparisons may be made in Logistic
regression. See the Details section.}

\item{nSims}{A positive integer. Controls the number of simulated
draws to make if the model is Poisson.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values and
    probabilities attached.
}
\description{
This is the method \code{add_probs} uses if the model fit is an
object of class \code{glm}. Probabilities are determined through
simulation, using the same method as \code{add_pi.glm}. Currently,
only logistic, Poisson, Quasipoisson, and Gamma models are
supported.
}
\details{
Any of the five comparisons may be made for a Poisson,
quasipoisson, or Gamma model: \code{comparison = "<"}, \code{">"},
\code{"="}, \code{"<="}, or \code{">="}. For logistic regression,
the comparison statement must be equivalent to \eqn{Pr(Y|x = 0)} or
\eqn{Pr(Y|x = 1)}.

If \code{add_probs} is called on a Poisson, quasiPoisson or Gamma
model, a simulation is performed using \code{arm::sim}.

If \code{add_probs} is called on a logistic model, the fitted
probabilities are used directly (no simulation is required).

If \code{add_probs} is called on a Gaussian GLM, the returned
probabilities are identical to those given by
\code{add_probs.lm}. In this case, the comparisons \code{<} and
\code{<=} are identical (likewise for \code{>} and \code{>=}). If
the comparison \code{=} is used in the Gaussian GLM, an informative
error is returned.
}
\examples{
# Fit a Poisson model
fit <- glm(dist ~ speed, data = cars, family = "poisson")

# Determine the probability that a new dist is less than 20, given
# the Poisson model.
add_probs(cars, fit, q = 20)

# Determine the probability that a new dist is greater than 20,
# given the Poisson model.
add_probs(cars, fit, q = 30, comparison = ">")

# Determine the probability that a new dist is greater than or
# equal to 20, given the Poisson model.
add_probs(cars, fit, q = 30, comparison = ">=")

# Fit a logistic model
fit2 <- glm(I(dist > 30) ~ speed, data = cars, family = "binomial")
add_probs(cars, fit2, q = 0, comparison = "=")
add_probs(cars, fit2, q = 1, comparison = "=")

}
\seealso{
\code{\link{add_ci.glm}} for confidence intervals for
    \code{glm} objects, \code{\link{add_pi.glm}} for prediction
    intervals of \code{glm} objects, and
    \code{\link{add_quantile.glm}} for response quantiles of
    \code{glm} objects.
}
