% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ci_glmer.R
\name{add_ci.glmerMod}
\alias{add_ci.glmerMod}
\title{Confidence Intervals for Generalized Linear Mixed Model Predictions}
\usage{
\method{add_ci}{glmerMod}(tb, fit, alpha = 0.05, names = NULL,
  yhatName = "pred", response = TRUE, type = "boot",
  includeRanef = TRUE, nSims = 500, ...)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{glmerMod}.}

\item{alpha}{A real number between 0 and 1. Controls the confidence
level of the interval estimates.}

\item{names}{\code{NULL} or character vector of length two. If
\code{NULL}, confidence bounds automatically will be named by
\code{add_ci}, otherwise, the lower confidence bound will be
named \code{names[1]} and the upper confidence bound will be
named \code{names[2]}.}

\item{yhatName}{\code{NULL} or a string. Name of the predictions
vector. If \code{NULL}, the predictions will be named
\code{pred}.}

\item{response}{A logical. The default is \code{TRUE}. If
\code{TRUE}, the confidence intervals will be determined for the
expected response; if \code{FALSE}, confidence intervals will be
made on the scale of the linear predictor.}

\item{type}{A string. If \code{type == "boot"} then bootstrap
intervals are formed. If \code{type == "parametric"} then
parametric intervals are formed. Currently only bootstrap
intervals are supported.}

\item{includeRanef}{A logical. Default is \code{TRUE}. Set whether
the predictions and intervals should be made conditional on the
random effects. If \code{FALSE}, random effects will not be
included.}

\item{nSims}{A positive integer.  Controls the number of bootstrap
replicates if \code{type = "boot"}.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values, upper and lower
  confidence bounds attached.
}
\description{
This function is one of the methods for \code{add_ci}, and is
called automatically when \code{add_ci} is used on a \code{fit} of
class \code{glmerMod}.
}
\details{
There are two methods one can use to calculate confidence intervals
for GLMM fits: bootstrap or parametric. The default and recommended
method is bootstrap. The bootstrap method can handle many types of
models and we find it to be generally reliable and robust as it is
built on the \code{bootMer} function from \code{lme4}. An
experimental parametric method is included that mimics the
functionality of \code{add_ci.lmer}'s default method. We caution
against using this method because presently it only works for GLMMs
that have a single random intercept term, and tends to provide
intervals that are wider than the intervals supplied by the
bootstrap method. A simulation study on this discrepancy is
pending.
}
\examples{
n <- 300
x <- runif(n)
f <- factor(sample(1:5, size = n, replace = TRUE))
y <- rpois(n, lambda = exp(1 - 0.05 * x * as.numeric(f) + 2 * as.numeric(f)))
tb <- tibble::tibble(x = x, f = f, y = y)
fit <- lme4::glmer(y ~ (1+x|f), data=tb, family = "poisson")

\dontrun{add_ci(tb, fit, names = c("lcb", "ucb"), nSims = 300)}

}
\references{
For general information about GLMMs
    http://bbolker.github.io/mixedmodels-misc/glmmFAQ.html
}
\seealso{
\code{\link{add_pi.glmerMod}} for prediction intervals
    of \code{glmerMod} objects, \code{\link{add_probs.glmerMod}} for
    conditional probabilities of \code{glmerMod} objects, and
    \code{\link{add_quantile.glmerMod}} for response quantiles of
    \code{glmerMod} objects.
}
