% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassPrintFunctions.R
\name{print_all.circGLM}
\alias{print_all.circGLM}
\title{Print all results from a circGLM object}
\usage{
print_all.circGLM(m, digits = 3)
}
\arguments{
\item{m}{A \code{circGLM} object.}

\item{digits}{Number of digits to display.}
}
\description{
This function prints the full list of results from a \code{circGLM} object. The function extracts all
the scalar results and displays these together, then prints all further list elements. The full
chains are not printed.
}
\examples{
print(circGLM(th = rvmc(10, 1, 1)), type = "all")

dat <- generateCircGLMData()
cglmmod <- circGLM(th ~ ., dat)
print(cglmmod, type = "all")
}
\seealso{
\code{\link{print_text.circGLM}}, \code{\link{print_mcmc.circGLM}},
  \code{\link{print_coef.circGLM}}, \code{\link{print.circGLM}}.
}
