% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassFunctions.R
\name{predict.circGLM}
\alias{predict.circGLM}
\title{Obtain predictions for the circGLM model}
\usage{
\method{predict}{circGLM}(object, newdata, ...)
}
\arguments{
\item{object}{A \code{circGLM} object.}

\item{newdata}{A data frame with predictors. The predictors must be the same
as used in the \code{circGLM} object and must have the same column names.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A numeric vector with predictions.
}
\description{
Obtain predictions from the original dataset, or the predictions from the
fitted model on a new dataset \code{newdata}.
}
\examples{
dat <- generateCircGLMData()
m   <- circGLM(th ~ ., dat)

# Predictions for the original outcome angles.
predict(m)

# Predictions for new data
dat2  <- generateCircGLMData()
predict(m, newdata = dat2)
}
