% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{get_build_artifacts}
\alias{get_build_artifacts}
\title{Get Build Artifacts of a Specific Job}
\usage{
get_build_artifacts(
  job_id = NULL,
  repo = github_info()$name,
  user = github_info()$owner$login,
  vcs_type = "gh",
  api_version = "v2"
)
}
\arguments{
\item{job_id}{\verb{[character]}\cr
A Circle CI job id.}

\item{repo}{\verb{[character]}\cr
The repository slug to use. Must follow the "\code{user/repo}" structure.}

\item{user}{\verb{[character]}\cr
The username for the repository. By default queried using \code{get_user()}.}

\item{vcs_type}{\verb{[character]}\cr The version control system to use.
Defaults to "gh" (Github).}

\item{api_version}{\verb{[character]}\cr
A character string specifying the Circle CI API version.
This usually does not need to be changed by the user.}
}
\value{
An object of class \code{circle_api} with the following elements
\itemize{
\item \code{content} (queried content)
\item \code{path} (API request)
\item \code{response} (HTTP response information)
}
}
\description{
Retrieve artifacts from a specific build.
}
\examples{
\dontrun{
job_id <- get_jobs()[[1]]$id
get_build_artifacts(job_id)
}
}
