% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-geom.R
\name{ccTrackText}
\alias{ccTrackText}
\title{Add texts on all sections of a single track.}
\usage{
ccTrackText(
  sectors,
  x,
  y,
  labels,
  direction = NULL,
  facing = c("inside", "outside", "reverse.clockwise", "clockwise", "downward",
    "bending", "bending.inside", "bending.outside"),
  niceFacing = FALSE,
  adj = par("adj"),
  cex = 1,
  col = par("col"),
  font = par("font"),
  factors = sectors
)
}
\arguments{
\item{sectors}{A \code{\link{factor}} or a character vector which represents the categories of data}

\item{x}{Data points on x-axis}

\item{y}{Data points on y-axis}

\item{labels}{Labels}

\item{direction}{deprecated, use \code{facing} instead.}

\item{facing}{Facing of text}

\item{niceFacing}{Should the facing of text be adjusted to fit human eyes?}

\item{adj}{Adjustment for text}

\item{cex}{Font size}

\item{col}{Font color}

\item{font}{Font style}

\item{factors}{The same as \code{sectors}. It will be removed in future versions. }
}
\value{
Object \linkS4class{ccTrackGeom}
}
\description{
Object \linkS4class{ccTrackGeom} will call the function \link[circlize:circos.trackText]{circlize::circos.trackText} while drawing.
}
\examples{
NULL
}
