#' Child and Adolescent Interpersonal Survey
#'
#' Information about the Child and Adolescent Interpersonal Survey (CAIS).
#'
#' @source Sodano, S. M., & Tracey, T. J. G. (2006). Interpersonal traits in
#'   childhood: Development of the Child and Adolescent Interpersonal Survey.
#'   *Journal of Personality Assessment, 87*(3), 317–329.
#' @source \doi{10.1207/s15327752jpa8703_12}
#' @keywords internal
#' @examples
#' summary(cais)
#' scales(cais, items = TRUE)
"cais"


#' Circumplex Scales of Interpersonal Efficacy
#'
#' Information about the Circumplex Scales of Interpersonal Efficacy (CSIE).
#'
#' @source Locke, K. D., & Sadler, P. (2007). Self-efficacy, values, and
#'   complementarity in dyadic interactions: Integrating interpersonal and
#'   social-cognitive theory. *Personality and Social Psychology Bulletin,
#'   33*(1), 94-109.
#' @source \url{https://kennethlocke.org/CSIE/CSIE.html}
#' @keywords internal
#' @examples
#' summary(csie)
#' scales(csie, items = TRUE)
"csie"

#' Circumplex Scales of Intergroup Goals
#'
#' Information about the Circumplex Scales of Intergroup Goals (CSIG).
#'
#' @source Locke, K. D. (2014). Circumplex scales of intergroup goals: An
#'   interpersonal circle model of goals for interactions between groups.
#'   *Personality and Social Psychology Bulletin, 40*(4), 433-449.
#' @source \url{https://kennethlocke.org/CSIG/CSIG.html}
#' @keywords internal
#' @examples
#' summary(csig)
#' scales(csig, items = TRUE)
"csig"

#' Circumplex Scales of Interpersonal Problems
#'
#' Information about the Circumplex Scales of Interpersonal Problems (CSIP).
#'
#' @source Boudreaux, M. J., Ozer, D. J., Oltmanns, T. F., & Wright, A. G. C.
#'   (2018). Development and validation of the circumplex scales of
#'   interpersonal problems. *Psychological Assessment, 30*(5), 594-609.
#' @source \doi{10.1037/pas0000505}
#' @keywords internal
#' @examples
#' summary(csip)
#' scales(csip, items = TRUE)
"csip"

#' Circumplex Scales of Interpersonal Values
#'
#' Information about the Circumplex Scales of Interpersonal Values (CSIV).
#'
#' @source Locke, K. D. (2000). Circumplex scales of interpersonal values:
#'   Reliability, validity, and applicability to interpersonal problems and
#'   personality disorders. *Journal of Personality Assessment, 75*(2), 249-267.
#' @source \url{https://kennethlocke.org/CSIV/CSIV.html}
#' @keywords internal
#' @examples
#' summary(csiv)
#' scales(csiv, items = TRUE)
"csiv"

#' Interpersonal Emotion Inventory
#'
#' Information about the Interpersonal Emotion Inventory (IEI).
#'
#' @source Horner, M. S., Locke, K. D., & Hulsey, T. L. (in press). Assessing
#'   affective dimensions of the interpersonal circumplex: development and
#'   validation of the interpersonal emotion inventory. *Journal of Personality
#'   Assessment*. Advanced online publication.
#' @source \doi{10.1080/00223891.2024.2400266}
#' @source \url{https://kennethlocke.org/IEI/IEI.html}
#' @keywords internal
#' @examples
#' summary(iei)
#' scales(iei, items = TRUE)
"iei"

#' Interpersonal Goals Inventory for Children, Revised Version
#'
#' Information about the Interpersonal Goals Inventory for Children, Revised
#' Version (IGI-CR).
#'
#' @source Trucco, E. M., Wright, A. G. C., & Colder, C. R. (2013). A revised
#'   interpersonal circumplex inventory of children’s social goals. *Assessment,
#'   20*(1), 98-113.
#' @source \doi{10.1177/1073191111411672}
#' @keywords internal
#' @examples
#' summary(igicr)
#' scales(igicr, items = TRUE)
"igicr"

#' Inventory of Interpersonal Problems, Brief Version
#'
#' Information about the Inventory of Interpersonal Problems, Brief Version
#' (IIP-32). Note that, although we have permission to provide some information
#' about the IIP-32, Mind Garden Inc. has exclusive rights to distribute it in
#' full.
#'
#' @source Horowitz, L. M., Alden, L. E., Wiggins, J. S., & Pincus, A. L.
#'   (2000). *IIP-64/IIP-32 professional manual.* San Antonio, TX: The
#'   Psychological Corporation.
#' @source \url{https://www.mindgarden.com/113-inventory-of-interpersonal-problems}
#' @keywords internal
#' @examples
#' summary(iip32)
"iip32"

#' Inventory of Interpersonal Problems
#'
#' Information about the Inventory of Interpersonal Problems (IIP-64). Note
#' that, although we have permission to provide some information about the
#' IIP-64, Mind Garden Inc. has exclusive rights to distribute it in full.
#'
#' @source Horowitz, L. M., Alden, L. E., Wiggins, J. S., & Pincus, A. L.
#'   (2000). *IIP-64/IIP-32 professional manual.* San Antonio, TX: The
#'   Psychological Corporation.
#' @source \url{https://www.mindgarden.com/113-inventory-of-interpersonal-problems}
#' @keywords internal
#' @examples
#' summary(iip64)
"iip64"

#' Inventory of Interpersonal Problems, Short Circumplex
#'
#' Information about the Inventory of Interpersonal Problems Short Circumplex
#' (IIP-SC).
#'
#' @source Soldz, S., Budman, S., Demby, A., & Merry, J. (1995). A short form of
#'   the Inventory of Interpersonal Problems Circumplex Scales. *Assessment,
#'   2*(1), 53-63.
#' @source \doi{10.1080/00223890802388665}
#' @keywords internal
#' @examples
#' summary(iipsc)
"iipsc"

#' Inventory of Interpersonal Strengths, Brief Version
#'
#' Information about the Inventory of Interpersonal Strengths, Brief Version
#' (IIS-32).
#'
#' @source Hatcher, R. L., & Rogers, D. T. (2012). The IIS-32: A brief inventory
#'   of interpersonal strengths. *Journal of Personality Assessment, 94*(6),
#'   638-646.
#' @source \doi{10.1080/00223891.2012.681818}
#' @keywords internal
#' @examples
#' summary(iis32)
#' scales(iis32, items = TRUE)
"iis32"

#' Inventory of Interpersonal Strengths
#'
#' Information about the Inventory of Interpersonal Strengths (IIS-64).
#'
#' @source Hatcher, R. L., & Rogers, D. T. (2009). Development and validation of
#'   a measure of interpersonal strengths: The Inventory of Interpersonal
#'   Strengths. *Psychological Assessment, 21*(4), 554-569.
#' @source \doi{10.1037/a0017269}
#' @keywords internal
#' @examples
#' summary(iis64)
#' scales(iis64, items = TRUE)
"iis64"

#' Inventory of Influence Tactics Circumplex
#'
#' Information about the Inventory of Influence Tactics Circumplex (IIT-C).
#'
#' @source Bliton, C. F., & Pincus, A. L. (in press). Construction and
#'   Validation of the Interpersonal Influence Tactics Circumplex (IIT-C)
#'   Scales. *Assessment*.
#' @source \doi{10.1177/1073191119864661}
#' @keywords internal
#' @examples
#' summary(iitc)
#' scales(iitc, items = TRUE)
"iitc"

#' IPIP Interpersonal Circumplex
#'
#' Information about the IPIP Interpersonal Circumplex (IPIP-IPC).
#'
#' @source Markey, P. M., & Markey, C. N. (2009). A brief assessment of the
#'   interpersonal circumplex: The IPIP-IPC. *Assessment, 16*(4), 352-361.
#' @source \doi{10.1177/1073191109340382}
#' @keywords internal
#' @examples
#' summary(ipipipc)
#' scales(ipipipc, items = TRUE)
"ipipipc"

#' Interpersonal Sensitivities Circumplex
#'
#' Information about the Interpersonal Sensitivities Circumplex (ISC).
#'
#' @source Hopwood, C. J., Ansell, E. B., Pincus, A. L., Wright, A. G. C.,
#'   Lukowitsky, M. R., & Roche, M. J. (2011). The circumplex structure of
#'   interpersonal sensitivities. *Journal of Personality, 79*(4), 707-740.
#' @source \doi{10.1111/j.1467-6494.2011.00696.x}
#' @keywords internal
#' @examples
#' summary(isc)
#' scales(isc, items = TRUE)
"isc"
