% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciu.R
\name{ciu.ggplot}
\alias{ciu.ggplot}
\title{ciu.ggplot}
\usage{
ciu.ggplot(
  ciu,
  instance,
  ind.input = 1,
  ind.output = 1,
  in.min.max.limits = NULL,
  n.points = 40,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  ylim = NULL,
  illustrate.CIU = FALSE,
  neutral.CU = 0.5,
  CIU.illustration.colours = c("red", "orange", "green", "blue")
)
}
\arguments{
\item{ciu}{\code{ciu} object as created with \link{ciu} function (not to be confused
with \code{CIU} object as created by \link{ciu.new}).}

\item{instance}{Input values for the instance to explain. Should be a
\link{data.frame} even though a \code{vector} or \code{matrix} might work too if input
names and other needed metadata can be deduced from the dataset or other
parameters given to \code{\link{ciu.new}}.}

\item{ind.input}{Index of input feature to plot.}

\item{ind.output}{Index of output to plot.}

\item{in.min.max.limits}{\link{data.frame} or \link{matrix} with one row per output
and two columns, where the first column indicates the minimal value and the
second column the maximal value for that output. ONLY NEEDED HERE IF not
given as parameter to \link{ciu.new} or if the limits are different for this
specific instance than the default ones.}

\item{n.points}{How many x,y pairs will be calculated, equally spaced over in.min.max.limits.}

\item{main}{Text to use as main title.}

\item{xlab}{Label for x-axis.}

\item{ylab}{Label for y-axis.}

\item{ylim}{Minimal and maximal values for y-axis.}

\item{illustrate.CIU}{Include illustration of CIU Cmin, Cmax, neutral.CU. Default is FALSE}

\item{neutral.CU}{Value of neutral.CU. Default is 0.5.}

\item{CIU.illustration.colours}{Colours to use for illustrating CIU.
Default is red, orange, green.}
}
\value{
ggplot object.
}
\description{
Function for plotting out the effect of changing values of one input on one output.
}
\author{
Kary Främling
}
