% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaExplain.R
\name{ciu.meta.result.new}
\alias{ciu.meta.result.new}
\title{CIU meta-result object}
\usage{
ciu.meta.result.new(
  ciu,
  instance,
  ciuvals,
  ind.inputs = NULL,
  inp.names = NULL,
  in.min.max.limits = NULL,
  n.samples = NULL,
  target.concept = NULL,
  target.ciu = NULL
)
}
\arguments{
\item{ciu}{\code{ciu} object as created with \link{ciu} function (not to be confused
with \code{CIU} object as created by \link{ciu.new}).}

\item{instance}{Input values for the instance to explain. Should be a
\link{data.frame} even though a \code{vector} or \code{matrix} might work too if input
names and other needed metadata can be deduced from the dataset or other
parameters given to \code{\link{ciu.new}}.}

\item{ciuvals}{List of \code{ciu.result} objects, one per input feature.}

\item{ind.inputs}{Indices of input features to explain (the set {i} in CIU
formulae)}

\item{inp.names}{Names of the input features.}

\item{in.min.max.limits}{\link{data.frame} or \link{matrix} with one row per output
and two columns, where the first column indicates the minimal value and the
second column the maximal value for that output. ONLY NEEDED HERE IF not
given as parameter to \link{ciu.new} or if the limits are different for this
specific instance than the default ones.}

\item{n.samples}{How many instances to generate for estimating CI and CU.
For inputs of type \link{factor}, all possible combinations of input values
are generated, so this parameter only influences how many instances are
(at least) generated for continuous-valued inputs.}

\item{target.concept}{If provided, then calculate CIU of inputs
\code{ind.inputs.to.explain} relative to the given concept rather than
relative to the actual output(s). \code{ind.inputs.to.explain} should
normally be a subset (or all) of the inputs that \code{target.concept}
consists of, even though that not required by the CIU calculation.
If a \code{target.ciu} is provided, then the \code{target.concept} doesn't have to
be included in the \code{vocabulary} gives as parameter to \link{ciu.new}
(at least for the moment).}

\item{target.ciu}{\code{ciu.result} object previously calculated for
\code{target.concept}. If a \code{target.concept} is provided but \code{target.ciu=NULL},
then \code{target.ciu} is estimated by a call to \link{ciu.explain} with the
\code{n.samples} value given as a parameter to this call. It may be useful
to provide \code{target.ciu} if it should be estimated using some other
(typically greater) value for \code{n.samples} than the default one, or if it
has already been calculated for some reason.}
}
\value{
An object of class ciu.meta.result, which is a \link{list} with
same elements as the given parameters.
}
\description{
Create object of class \code{ciu.meta.result}, which stores results of CIU
calculations together with their "meta-data".
The \code{\link[=ciu.meta.explain]{ciu.meta.explain()}} method returns a \code{ciu.meta.result} object.
}
\author{
Kary Främling
}
