% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{models_put_archive}
\alias{models_put_archive}
\title{Update the archive status of this object}
\usage{
models_put_archive(id, status)
}
\arguments{
\item{id}{integer required. The ID of the object.}

\item{status}{boolean required. The desired archived status of the object.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the model.}
\item{tableName}{string, The qualified name of the table containing the training set from which to build the model.}
\item{databaseId}{integer, The ID of the database holding the training set table used to build the model.}
\item{credentialId}{integer, The ID of the credential used to read the target table. Defaults to the user's default credential.}
\item{modelName}{string, The name of the model.}
\item{description}{string, A description of the model.}
\item{interactionTerms}{boolean, Whether to search for interaction terms.}
\item{boxCoxTransformation}{boolean, Whether to transform data so that it assumes a normal distribution. Valid only with continuous models.}
\item{modelTypeId}{integer, The ID of the model's type.}
\item{primaryKey}{string, The unique ID (primary key) of the training dataset.}
\item{dependentVariable}{string, The dependent variable of the training dataset.}
\item{dependentVariableOrder}{array, The order of dependent variables, especially useful for Ordinal Modeling.}
\item{excludedColumns}{array, A list of columns which will be considered ineligible to be independent variables.}
\item{limitingSQL}{string, A custom SQL WHERE clause used to filter the rows used to build the model. (e.g., "id > 105").}
\item{activeBuildId}{integer, The ID of the current active build, the build used to score predictions.}
\item{crossValidationParameters}{object, Cross validation parameter grid for tree methods, e.g. {"n_estimators": [100, 200, 500], "learning_rate": [0.01, 0.1], "max_depth": [2, 3]}.}
\item{numberOfFolds}{integer, Number of folds for cross validation. Default value is 5.}
\item{notifications}{object, A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on.
\item failureOn boolean, If failure email notifications are on.
}}
\item{schedule}{object, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the object is scheduled
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday
\item scheduledHours array, Hours of the day it is scheduled on
\item scheduledMinutes array, Minutes of the day it is scheduled on
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour
}}
\item{parentId}{integer, The ID of the parent job that will trigger this model.}
\item{runningAs}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{timeZone}{string, The time zone of this model.}
\item{lastRun}{object, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{hidden}{boolean, The hidden status of the object.}
\item{user}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{createdAt}{string, The time the model was created.}
\item{updatedAt}{string, The time the model was updated.}
\item{currentBuildState}{string, The status of the current model build. One of "succeeded", "failed", "queued", or "running,"or "idle", if no build has been attempted.}
\item{currentBuildException}{string, Exception message, if applicable, of the current model build.}
\item{builds}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of the model build.
\item name string, The name of the model build.
\item createdAt string, The time the model build was created.
\item description string, A description of the model build.
\item rootMeanSquaredError number, A key metric for continuous models. Nil for other model types.
\item rSquaredError number, A key metric for continuous models. Nil for other model types.
\item rocAuc number, A key metric for binary, multinomial, and ordinal models. Nil for other model types.
}}
\item{predictions}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of the model to which to apply the prediction.
\item tableName string, The qualified name of the table on which to apply the predictive model.
\item primaryKey array, The primary key or composite keys of the table being predicted.
\item limitingSQL string, A SQL WHERE clause used to scope the rows to be predicted.
\item outputTable string, The qualified name of the table to be created which will contain the model's predictions.
\item schedule object, 
\item state string, The status of the prediction. One of: "succeeded", "failed", "queued", or "running,"or "idle", if no build has been attempted.
}}
\item{lastOutputLocation}{string, The output JSON for the last build.}
\item{archived}{string, The archival status of the requested object(s).}
}
\description{
Update the archive status of this object
}
