% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{jobs_list}
\alias{jobs_list}
\title{List}
\usage{
jobs_list(state = NULL, type = NULL, q = NULL, permission = NULL,
  scheduled = NULL, hidden = NULL, archived = NULL, limit = NULL,
  page_num = NULL, order = NULL, order_dir = NULL)
}
\arguments{
\item{state}{string optional. The job's state. One or more of queued, running, succeeded, failed, and cancelled. Specify multiple values as a comma-separated list (e.g., "A,B").}

\item{type}{string optional. The job's type. Specify multiple values as a comma-separated list (e.g., "A,B").}

\item{q}{string optional. Query string to search on the id, name, and job type}

\item{permission}{string optional. A permissions string, one of "read", "write", or "manage". Lists only jobs for which the current user has that permission.}

\item{scheduled}{boolean optional. If the object is scheduled.}

\item{hidden}{boolean optional. If specified to be true, returns hidden objects. Defaults to false, returning non-hidden objects.}

\item{archived}{string optional. The archival status of the requested object(s).}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, }
\item{name}{string, }
\item{type}{string, }
\item{fromTemplateId}{integer, }
\item{state}{string, Whether the job is idle, queued, running, cancelled, or failed.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{lastRun}{object, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{archived}{string, The archival status of the requested object(s).}
\item{schedule}{object, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the object is scheduled
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday
\item scheduledHours array, Hours of the day it is scheduled on
\item scheduledMinutes array, Minutes of the day it is scheduled on
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour
}}
}
\description{
List
}
