% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{templates_list_scripts}
\alias{templates_list_scripts}
\title{List Script Templates}
\usage{
templates_list_scripts(
  hidden = NULL,
  category = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{hidden}{boolean optional. If specified to be true, returns hidden items. Defaults to false, returning non-hidden items.}

\item{category}{string optional. A category to filter results by, one of: import, export, enhancement, model, and script}

\item{limit}{integer optional. Number of results to return. Defaults to 50. Maximum allowed is 1000.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to name. Must be one of: name, updated_at, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, }
\item{public}{boolean, If the template is public or not.}
\item{scriptId}{integer, The id of the script that this template uses.}
\item{userContext}{string, The user context of the script that this template uses.}
\item{name}{string, The name of the template.}
\item{category}{string, The category of this template.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{useCount}{integer, The number of uses of this template.}
\item{uiReportId}{integer, The id of the report that this template uses.}
\item{techReviewed}{boolean, Whether this template has been audited by Civis for security vulnerability and correctness.}
\item{archived}{boolean, Whether the template has been archived.}
}
\description{
List Script Templates
}
