% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{users_patch_me}
\alias{users_patch_me}
\title{Update info about the logged-in user}
\usage{
users_patch_me(preferences = NULL, last_checked_announcements = NULL)
}
\arguments{
\item{preferences}{list optional. A list containing the following elements: 
\itemize{
\item appIndexOrderField string, This attribute is deprecated
\item appIndexOrderDir string, This attribute is deprecated
\item resultIndexOrderField string, Order field for the reports index page.
\item resultIndexOrderDir string, Order direction for the reports index page.
\item resultIndexTypeFilter string, Type filter for the reports index page.
\item resultIndexAuthorFilter string, Author filter for the reports index page.
\item resultIndexArchivedFilter string, Archived filter for the reports index page.
\item importIndexOrderField string, Order field for the imports index page.
\item importIndexOrderDir string, Order direction for the imports index page.
\item importIndexTypeFilter string, Type filter for the imports index page.
\item importIndexAuthorFilter string, Author filter for the imports index page.
\item importIndexDestFilter string, Destination filter for the imports index page.
\item importIndexStatusFilter string, Status filter for the imports index page.
\item importIndexArchivedFilter string, Archived filter for the imports index page.
\item exportIndexOrderField string, Order field for the exports index page.
\item exportIndexOrderDir string, Order direction for the exports index page.
\item exportIndexTypeFilter string, Type filter for the exports index page.
\item exportIndexAuthorFilter string, Author filter for the exports index page.
\item exportIndexStatusFilter string, Status filter for the exports index page.
\item modelIndexOrderField string, Order field for the models index page.
\item modelIndexOrderDir string, Order direction for the models index page.
\item modelIndexAuthorFilter string, Author filter for the models index page.
\item modelIndexStatusFilter string, Status filter for the models index page.
\item modelIndexArchivedFilter string, Archived filter for the models index page.
\item modelIndexThumbnailView string, Thumbnail view for the models index page.
\item scriptIndexOrderField string, Order field for the scripts index page.
\item scriptIndexOrderDir string, Order direction for the scripts index page.
\item scriptIndexTypeFilter string, Type filter for the scripts index page.
\item scriptIndexAuthorFilter string, Author filter for the scripts index page.
\item scriptIndexStatusFilter string, Status filter for the scripts index page.
\item scriptIndexArchivedFilter string, Archived filter for the scripts index page.
\item projectIndexOrderField string, Order field for the projects index page.
\item projectIndexOrderDir string, Order direction for the projects index page.
\item projectIndexAuthorFilter string, Author filter for the projects index page.
\item projectIndexArchivedFilter string, Archived filter for the projects index page.
\item reportIndexThumbnailView string, Thumbnail view for the reports index page.
\item projectDetailOrderField string, Order field for projects detail pages.
\item projectDetailOrderDir string, Order direction for projects detail pages.
\item projectDetailAuthorFilter string, Author filter for projects detail pages.
\item projectDetailTypeFilter string, Type filter for projects detail pages.
\item projectDetailArchivedFilter string, Archived filter for the projects detail pages.
\item enhancementIndexOrderField string, Order field for the enhancements index page.
\item enhancementIndexOrderDir string, Order direction for the enhancements index page.
\item enhancementIndexAuthorFilter string, Author filter for the enhancements index page.
\item enhancementIndexArchivedFilter string, Archived filter for the enhancements index page.
\item preferredServerId integer, ID of preferred server.
\item civisExploreSkipIntro boolean, Whether the user is shown steps for each exploration.
\item registrationIndexOrderField string, Order field for the registrations index page.
\item registrationIndexOrderDir string, Order direction for the registrations index page.
\item registrationIndexStatusFilter string, Status filter for the registrations index page.
\item upgradeRequested string, Whether a free trial upgrade has been requested.
\item welcomeOrderField string, Order direction for the welcome page.
\item welcomeOrderDir string, Order direction for the welcome page.
\item welcomeAuthorFilter string, Status filter for the welcome page.
\item welcomeStatusFilter string, Status filter for the welcome page.
\item welcomeArchivedFilter string, Status filter for the welcome page.
\item dataPaneWidth string, Width of the data pane when expanded.
\item dataPaneCollapsed string, Whether the data pane is collapsed.
\item notebookOrderField string, Order field for the notebooks page.
\item notebookOrderDir string, Order direction for the notebooks page.
\item notebookAuthorFilter string, Author filter for the notebooks page.
\item notebookArchivedFilter string, Archived filter for the notebooks page.
\item notebookStatusFilter string, Status filter for the notebooks page.
\item workflowIndexOrderField string, Order field for the workflows page.
\item workflowIndexOrderDir string, Order direction for the workflows page.
\item workflowIndexAuthorFilter string, Author filter for the workflows page.
\item workflowIndexArchivedFilter string, Archived filter for the workflows page.
\item serviceOrderField string, Order field for the services page.
\item serviceOrderDir string, Order direction for the services page.
\item serviceAuthorFilter string, Author filter for the services page.
\item serviceArchivedFilter string, Archived filter for the services page.
\item assumeRoleHistory string, JSON string of previously assumed roles.
\item defaultSuccessNotificationsOn boolean, Whether email notifications for the success of all applicable jobs are on by default.
\item defaultFailureNotificationsOn boolean, Whether email notifications for the failure of all applicable jobs are on by default.
\item myActivityMetrics boolean, Whether the activity metrics are filtered to the current user.
}}

\item{last_checked_announcements}{string optional. The date and time at which the user last checked their announcements.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of this user.}
\item{name}{string, This user's name.}
\item{email}{string, This user's email address.}
\item{username}{string, This user's username.}
\item{initials}{string, This user's initials.}
\item{lastCheckedAnnouncements}{string, The date and time at which the user last checked their announcements.}
\item{featureFlags}{list, The feature flag settings for this user.}
\item{roles}{array, The roles this user has, listed by slug.}
\item{preferences}{list, This user's preferences.}
\item{customBranding}{string, The branding of Platform for this user.}
\item{primaryGroupId}{integer, The ID of the primary group of this user.}
\item{groups}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of this group.
\item name string, The name of this group.
\item slug string, The slug of this group.
\item organizationId integer, The ID of the organization associated with this group.
\item organizationName string, The name of the organization associated with this group.
}}
\item{organizationName}{string, The name of the organization the user belongs to.}
\item{organizationSlug}{string, The slug of the organization the user belongs to.}
\item{organizationDefaultThemeId}{integer, The ID of the organizations's default theme.}
\item{createdAt}{string, The date and time when the user was created.}
\item{signInCount}{integer, The number of times the user has signed in.}
\item{assumingRole}{boolean, Whether the user is assuming a role or not.}
\item{assumingAdmin}{boolean, Whether the user is assuming admin.}
\item{assumingAdminExpiration}{string, When the user's admin role is set to expire.}
\item{superadminModeExpiration}{string, The user is in superadmin mode when set to a DateTime. The user is not in superadmin mode when set to null.}
\item{disableNonCompliantFedrampFeatures}{boolean, Whether to disable non-compliant fedramp features.}
\item{personaRole}{string, The high-level role representing the current user's main permissions.}
\item{createdById}{integer, The ID of the user who created this user.}
\item{lastUpdatedById}{integer, The ID of the user who last updated this user.}
}
\description{
Update info about the logged-in user
}
