% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sl_h2o_auto.R
\name{SL.h2o_auto}
\alias{SL.h2o_auto}
\title{Automatic machine learning using h2o}
\usage{
SL.h2o_auto(
  Y,
  X,
  newX,
  family,
  obsWeights,
  id,
  nthreads = 1,
  max_runtime_secs = NULL,
  max_models = 20,
  stopping_metric = NULL,
  stopping_rounds = 7,
  nfolds = 10,
  verbose = T,
  ...
)
}
\arguments{
\item{Y}{Outcome variable}

\item{X}{Covariate dataframe}

\item{newX}{Optional dataframe to predict the outcome}

\item{family}{"gaussian" for regression, "binomial" for binary
classification, "multinomial" for multiple classification (not yet supported).}

\item{obsWeights}{Optional observation-level weights (supported but not tested)}

\item{id}{Optional id to group observations from the same unit (not used
currently).}

\item{nthreads}{Number of threads to use, if h2o cluster not alreay started.}

\item{max_runtime_secs}{Maximum runtime in seconds, does not yield reproducible results.}

\item{max_models}{Maximum number of models to fit, key parameter to improve performance.}

\item{stopping_metric}{Metric to optimize towards.}

\item{stopping_rounds}{Stop if metric does not improve for this many consecutive rounds.}

\item{nfolds}{# of CV folds for internal cross-validation.}

\item{verbose}{If TRUE display extra output.}

\item{...}{Any remaining arguments, not used.}
}
\description{
Requires a recent version of h2o that has h2o.automl()
}
\examples{
# Enable data.table h2o import, which should be faster.
# Make sure data.table and slam R packages are installed too.
options("h2o.use.data.table" = TRUE)
\dontrun{
library(h2o)
# Start an h2o server with all (physical) cores usable.
local_h2o = h2o.init(nthreads = RhpcBLASctl::get_num_cores(),
                     # May need to specify extra memory.
                      max_mem_size = "8g")

library(SuperLearner)
h2o_auto = create.Learner("SL.h2o_auto",
        # Increase max models and stopping rounds for better models.
        # Decrease nfolds for faster training but less certainty.
                          params = list(max_models = 30,
                                        stopping_rounds = 5,
                                        nfolds = 10))
sl =
  SuperLearner(Y = Y, X = X,
               family = binomial(),
               SL.library = c("SL.mean", h2o_auto$names),
               verbose = T,
               # Stratify during CV in case of rare outcome.
               cvControl = SuperLearner.CV.control(V = 10L, stratifyCV = T))
print(sl)

h2o.shutdown()
}
}
