% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/resource_delete.R
\name{resource_delete}
\alias{resource_delete}
\title{Delete a resource.}
\usage{
resource_delete(id, key = get_default_key(), url = get_default_url(), ...)
}
\arguments{
\item{id}{(character) Resource identifier.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Delete a resource.
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "http://demo.ckan.org/", key = getOption("ckan_demo_key"))

# create a package
(res <- package_create("yellow9"))

# then create a resource
file <- system.file("examples", "actinidiaceae.csv", package = "ckanr")
(xx <- resource_create(res,
                       description = "my resource",
                       name = "bears",
                       upload = file,
                       rcurl = "http://google.com"
))

# delete the resource
resource_delete(xx)
}
}

