% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_show.R
\name{group_show}
\alias{group_show}
\title{Show a package}
\usage{
group_show(id, include_datasets = TRUE, url = get_default_url(),
  key = get_default_key(), as = "list", ...)
}
\arguments{
\item{id}{(character) Package identifier.}

\item{include_datasets}{(logical) Include a list of the group's datasets.
Default: TRUE}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Show a package
}
\details{
By default the help and success slots are dropped, and only the
   result slot is returned. You can request raw json with \code{as = 'json'}
   then parse yourself to get the help slot.
}
\examples{
\dontrun{
res <- group_list()

# via a group name/id
group_show(res[[1]]$name)

# or via an object of class ckan_group
group_show(res[[1]])

# return different data formats
group_show(res[[1]]$name, as = 'json')
group_show(res[[1]]$name, as = 'table')
}
}
