% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds_create.R
\name{ds_create}
\alias{ds_create}
\title{Add a new table to a datastore}
\usage{
ds_create(
  resource_id = NULL,
  resource = NULL,
  force = FALSE,
  aliases = NULL,
  fields = NULL,
  records = NULL,
  primary_key = NULL,
  indexes = NULL,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{resource_id}{(string) Resource id that the data is going to be stored
against.}

\item{resource}{(dictionary) Resource dictionary that is passed to
\code{\link[=resource_create]{resource_create()}}. Use instead of \code{resource_id} (optional)}

\item{force}{(logical) Set to \code{TRUE} to edit a read-only resource.
Default: \code{FALSE}}

\item{aliases}{(character) Names for read only aliases of the resource.
(optional)}

\item{fields}{(list) Fields/columns and their extra metadata. (optional)}

\item{records}{(list) The data, eg: \verb{[\{"dob": "2005", "some_stuff": ["a", "b"]\}]} (optional)}

\item{primary_key}{(character) Fields that represent a unique key (optional)}

\item{indexes}{(character) Indexes on table (optional)}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
BEWARE: This function still doesn't quite work yet.
}
\examples{
\dontrun{
ckanr_setup(url = "https://demo.ckan.org/",
  key = getOption("ckan_demo_key"))

# create a package
(res <- package_create("foobarrrrr", author="Jane Doe"))

# then create a resource
file <- system.file("examples", "actinidiaceae.csv", package = "ckanr")
(xx <- resource_create(package_id = res$id,
                       description = "my resource",
                       name = "bears",
                       upload = file,
                       rcurl = "http://google.com"
))
ds_create(resource_id = xx$id, records = iris, force = TRUE)
resource_show(xx$id)
}
}
\references{
\url{http://bit.ly/1G9cnBl}
}
