% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{calibrate}
\alias{calibrate}
\title{Calibrate individual 14C dates.}
\usage{
calibrate(
  cage = 2450,
  error = 50,
  reservoir = 0,
  prob = 0.95,
  cc = 1,
  cc1 = "IntCal13.14C",
  cc2 = "Marine13.14C",
  cc3 = "SHCal13.14C",
  cc4 = "mixed.14C",
  ccdir = "",
  postbomb = FALSE,
  pb1 = "postbomb_NH1.14C",
  pb2 = "postbomb_NH2.14C",
  pb3 = "postbomb_NH3.14C",
  pb4 = "postbomb_SH1-2.14C",
  pb5 = "postbomb_SH3.14C",
  yrsteps = 1,
  pbsteps = 0.01,
  hpdsteps = 1,
  calibt = FALSE,
  yrmin = NULL,
  yrmax = NULL,
  minC14 = NULL,
  maxC14 = NULL,
  times = 5,
  calheight = 0.3,
  expand = 0.1,
  threshold = 1e-06,
  storedat = FALSE,
  graph = TRUE,
  xlab = NULL,
  ylab = NULL,
  BCAD = FALSE,
  mar = c(3.5, 3, 2, 1),
  mgp = c(1.7, 0.8, 0),
  bty = "l",
  xaxs = "i",
  yaxs = "i",
  title = NULL,
  date.col = "red",
  cc.col = rgb(0, 0.5, 0, 0.7),
  dist.col = rgb(0, 0, 0, 0.3),
  sd.col = rgb(0, 0, 0, 0.5)
)
}
\arguments{
\item{cage}{Mean of the uncalibrated C-14 age.}

\item{error}{Error of the uncalibrated C-14 age.}

\item{reservoir}{Reservoir age, or reservoir age and age offset.}

\item{prob}{Probability confidence intervals (between 0 and 1).}

\item{cc}{Calibration curve for C-14 dates (1, 2, 3, or 4).}

\item{cc1}{For northern hemisphere terrestrial C-14 dates.}

\item{cc2}{For marine C-14 dates.}

\item{cc3}{For southern hemisphere C-14 dates.}

\item{cc4}{For mixed marine/terrestrial C-14 dates.}

\item{ccdir}{Directory where the calibration curves for C-14 dates \code{cc} are located. By default \code{ccdir=""}. 
Use \code{ccdir="."} to choose current working directory. Use \code{ccdir="/Curves"} to choose sub-folder \code{/Curves}.}

\item{postbomb}{Calibration curve for postbomb dates.}

\item{pb1}{For Northern hemisphere region 1 postbomb C-14 dates.}

\item{pb2}{For Northern hemisphere region 2 postbomb C-14 dates.}

\item{pb3}{For Northern hemisphere region 3 postbomb C-14 dates.}

\item{pb4}{For Southern hemisphere regions 1-2 postbomb C-14 dates.}

\item{pb5}{For Southern hemisphere region 3 postbomb C-14 dates.}

\item{yrsteps}{Temporal resolution at which C-14 ages are calibrated (in calendar years).}

\item{pbsteps}{Temporal resolution at which postbomb C-14 ages are calibrated (in calendar years).}

\item{hpdsteps}{Temporal resolution at which highest posterior density ranges are calibrated (in calendar years).}

\item{calibt}{Calibration based on the student-t distribution. By default, the Gaussian distribution is used (\code{calibt=FALSE}). To use the student-t distribution, provide two parameters such as \code{calibt=c(3,4)}.}

\item{yrmin}{Minimum of calendar axis (default calculated automatically).}

\item{yrmax}{Maximum of calendar axis (default calculated automatically).}

\item{minC14}{Minimum age of the C-14 age axis (default calculated automatically).}

\item{maxC14}{Maximum of the C-14 age axis (default calculated automatically).}

\item{times}{Half-range of calibration curve used to calibrate dates (multiplication factor for the date's errors).}

\item{calheight}{Maximum height of the C14 and calibrated distributions (as proportion of the invisible secondary axes).}

\item{expand}{By which ratio should the calendar axis be expanded to fit the calibrated distribution.}

\item{threshold}{Below which value should probabilities be excluded from calculations.}

\item{storedat}{Store the dates within the R session after a clam run.}

\item{graph}{Plot a graph of the calibrated date. If set to FALSE, only the hpd ranges will be given.}

\item{xlab}{Label of the horizontal axis. Defaults to the calendar scale, but alternative names can be provided.}

\item{ylab}{Label of the vertical axis. Defaults to the 14C scale, but alternative names can be provided.}

\item{BCAD}{Use BC/AD or cal BP scale (default cal BP).}

\item{mar}{Plot margins (amount of white space along edges of axes 1-4).}

\item{mgp}{Axis text margins (where should titles, labels and tick marks be plotted).}

\item{bty}{Draw a box around the graph ("n" for none, and "l", "7", "c", "u", "]" or "o" for correspondingly shaped boxes).}

\item{xaxs}{Whether or not to extend the limits of the horizontal axis. Defaults to \code{xaxs="i"} which does not extend the limits.}

\item{yaxs}{Whether or not to extend the limits of the vertical axis. Defaults to \code{yaxs="i"} which does not extend the limits.}

\item{title}{Title of the graph. Defaults to the values of the uncalibrated date.}

\item{date.col}{Colour of the "dot-bar" plot of the C14 date. Defaults to \code{date.col="red"}.}

\item{cc.col}{Colour of the calibration curve. Defaults to semi-transparent dark green; \code{cc.col=rgb(0,.5,0,0.7)}.}

\item{dist.col}{Colour of the calibrated distribution.}

\item{sd.col}{Colour of calibrated range.}
}
\value{
A graph of the raw and calibrated C-14 date, the calibrated ranges and, invisibly, the calibrated ranges and probabilities.
}
\description{
Calibrate individual 14C dates, plot them and report calibrated ranges.
}
\details{
Type \code{calibrate()} to see how a date of 2450 +- 50 14C BP gets calibrated (the calibration curve happens to show
a plateau around this 14C age). To calibrate a different date, provide its reported mean and error (1 
standard deviation error as reported by the radiocarbon laboratory) as follows: \code{calibrate(mean, error)},
e.g., for a date of 130 +- 20 14C BP, type calibrate\code{(cage=130, error=20)} or, shorter, \code{calibrate(130,20)}. 
As this date will fall partly beyond the younger extreme of the calibration curve, a warning will be given
(similar warnings will be given for too old dates).
  
In case the date has a reservoir effect or age offset, e.g. of 100 14C years, provide this as follows: 
\code{calibrate(130, 20, reservoir=100)}. If you want to include an uncertainty for this offset, provide this as follows,
e.g., for an uncertainty of 50yr, \code{calibrate(130,20,reservoir=c(100, 50))}. 
The uncertainty for the age offset will then be added to the error (by taking the square root of the sum 
of the squared error and the squared offset uncertainty). If the carbon of your sample has mixed marine/terrestrial sources,
instead apply the marine offset using \code{mix.calibrationcurves} \link{mix.calibrationcurves}, and calibrate the date using that custom-built curve.

If you prefer to work with, e.g., 68 \% as opposed to the default 95 \% confidence intervals, 
type: \code{calibrate(130, 20, prob=0.68)} or \code{calibrate(130, 20,, 0.68)} (the commas between the brackets indicate the position of the option;
the standard deviation is the fourth option of the \code{calibrate} function). Clam calculates the calibrated distribution 
for every single calendar year (\code{yrsteps=1}) within a wide range of the 14C date (default but adaptable \code{times=5}
standard deviations or 99.999999 \% of its probability distribution). This range can also be adapted by 
changing the option expand (default \code{expand=0.1}). Probabilities below a threshold (default \code{threshold=1e-6}) will be neglected.

By default the northern hemisphere terrestrial calibration curve is used (\code{cc=1, cc1="IntCal13.14C"}). 
To use alternative curves, use \code{cc=2} (\code{cc2="Marine13.14C"}), \code{cc=3} (\code{cc3="SHCal13.14C"}), 
\code{cc=4} (\code{cc4="mixed.14C"}), or change the file names of \code{cc1, cc2, cc3 or cc4}.
 
Clam works in cal BP (calendar years before AD 1950) by default, but can work with cal BC/AD through the option \code{BCAD=TRUE}. 

By default the Gaussian distribution is used to calibrate dates. For use of the student-t distribution instead, 
provide two sensible values, e.g., \code{calibt=c(3,4)}.

Calibrated distributions are usually reduced to their 68\% or 95\% calibrated ranges, taking into account the asymmetric 
and multi-peaked shape of these distributions. In clam, this is done by calculating the highest posterior density (hpd) ranges: 
\itemize{
\item i) the probability distribution (see above) is normalised to 100\%
\item ii) the calendar years are ranked according to their probabilities
\item iii) those calendar ages with a cumulative sum at or above the desired probability threshold (default 95\%) are retained, and 
\item iv) the extremes and probabilities of any sub-ranges within these calendar ages are reported. 
}
Calibrated ranges at 68\% will obviously result in narrower confidence intervals, and a perceived higher precision, than 95\% ranges. However, given the often
asymmetric and multi-modal nature of calibrated distributions, the probability that the 'true' calendar date 
lies outside the 1 standard deviation hpd ranges is considerable (c. 32\%). Therefore the use of 95\% calibrated ranges is preferable, 
and default in clam. The hpd ranges are calculated at yearly resolution by default (\code{hpdsteps=1}).

Negative radiocarbon ages are calibrated with postbomb curves, but the user needs to tell clam which curve to use. 
For example, to use the first of the three northern hemisphere curves, provide the option \code{postbomb=1}, 
while for southern hemisphere samples, use \code{postbomb=4} or \code{postbomb=5}. Default curves can be changed; 
currently they are \code{pb1="postbomb_NH1.14C"}, \code{pb2="postbomb_NH2.14C"}, \code{pb3="postbomb_NH3.14C"}, 
\code{pb4="postbomb_SH1-2.14C"} and \code{pb5="postbomb_SH3.14C"}; see \url{http://calib.org/CALIBomb/}. 
If no \code{postbomb} option is provided 
for negative radiocarbon ages, clam will report an error and refuse to calibrate the date. Given the sub-year resolution of postbomb-curves, 
hpd ranges are calculated at high resolution by default (\code{pbsteps=0.01}). Choose alternative values with care as 
they may cause unexpected results. 

Generally the calculations are removed from memory after calibration; 
if you want to have them stored (say for subsequent manipulations), provide the option \code{storedat=TRUE}.

A graph of the calibration is produced by default (\code{graph=TRUE}), and it can be adapted in several ways.
The limits of the horizontal (calendar scale) and vertical (14C scale) axes are calculated automatically 
but can be changed by providing alternative values for the options \code{yrmin, yrmax, minC14} and \code{maxC14}, respectively.
The titles of both axis can be changed by providing alternative titles to \code{xlab} and/or \code{ylab}, and 
also the top title can be adapted using title. The heights of the distributions of the 14C and calibrated 
ages can be set to alternative values using \code{calheight} (default \code{0.3} which plots the distribution up to 30\% of the height of the entire graph).
Parameters for white space around the 
graph can be changed (default \code{mar=c(3.5, 2, 2, 1}) for spacing below, to the left, above and to the right respectively), 
as can the spacing for the axis labels (\code{mgp=c(2,1,0)}). By default, the axes are connected at the lower left, \code{bty="l"}.
Check the R documentation of \code{par()} for more options.
  
The colours of the 14C date, the calibration curve, the entire distributions, as well as of the highest posterior density (\code{hpd}) 
ranges, can be changed by providing an alternative colour in \code{date.col}, \code{cc.col}, \code{dist.col}, and/or \code{sd.col}, respectively.
The default colours are transparent grey for the dates probability distributions (\code{dist.col=rgb(0,0,0, 0.3)} and \code{sd.col=rgb(0,0,0, 0.5)};
change the last value of rgb for different greyscale values), red for the uncalibrated mean and error bars (\code{date.col="red"}), 
and transparent green for the calibration curve (\code{cc.col=rgb(0, 0.5, 0, 0.7)}). R's rgb() function expects values between \code{0} and \code{1}
for red, green and blue, respectively, followed by a value for the semi-transparency (also between 0 and 1). Some graphic devices 
such as postscript are unable to use transparency; in that case provide different colours or leave the fourth value empty.
}
\examples{
calibrate()
calibrate(130, 20)
cal <- calibrate(2550, 20, reservoir=100)
cal; plot(cal$calib)
calibrate(130, 20, prob=0.68)
calibrate(cage=130, error=20)
calibrate(130, 20, reservoir=c(100, 50))
}
\author{
Maarten Blaauw
}
