% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_images.R
\name{tag_images}
\alias{tag_images}
\title{Tag Images on the Computer}
\usage{
tag_images(file_paths = NULL, model = NULL, language = NULL,
  meta = FALSE, simplify = TRUE, ...)
}
\arguments{
\item{file_paths}{a vactor of paths to image file(s) for which you want tags}

\item{model}{For topic specific answers. Optional. 
Can be one of the following: general-v1.3, nsfw-v1.0, weddings-v1.0, travel-v1.0, food-items-v0.1
Default is NULL}

\item{language}{Return tag in another language than english. 2 digit code. Optional. 
See \code{list{get_langs}} for the supported languages and their 2 digit codes.}

\item{meta}{Boolean that toggles whether or not you want the entire object.}

\item{simplify}{Boolean that toggles whether or not you want a simplified data frame with
each label and associated probability in a separate row. Default is TRUE.}

\item{...}{Additional arguments passed to \code{\link{clarifai_POST}}.

The entire object returned by the API contains a lot of meta data. 
By default a simplified data.frame with img_url, associated labels, and probabilities is returned.}
}
\value{
If meta is TRUE, a named list of length 4 with following elements is returned: 
\code{status_code} OK or not
\code{status_msg}  Successful or not
\code{meta} Named list of 1 containing another list named \code{tag}
Sublist \code{tag} has three elements: timestamp, model and config
\code{results} is a data.frame of length 6 and 1 row. Column names are:
\code{docid}, \code{status_code}, \code{status_msg}, \code{local_id} and 
a data.frame named tag which has a data.frame result which contains two columns: 
labels and probabilities

If meta is FALSE and simplify is TRUE,
a data.frame with three columns: file_paths, labels and probs returned

If meta is FALSE and simplify is FALSE,
a data.frame with two columns carrying a vector of labels, vector of probs is returned
for each image
}
\description{
Tag Images on the Computer
}
\examples{
\dontrun{
tag_images(file_paths="path_to_image")
}
}
\references{
\url{https://developer.clarifai.com/}
}
\seealso{
\code{\link{tag_image_urls}}
}

