% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_strsplit}
\alias{ansi_strsplit}
\title{Split an ANSI colored string}
\usage{
ansi_strsplit(x, split, ...)
}
\arguments{
\item{x}{Character vector, potentially ANSI styled, or a vector to
coarced to character.}

\item{split}{Character vector of length 1 (or object which can be coerced to
such) containing regular expression(s) (unless \code{fixed = TRUE}) to use
for splitting.  If empty matches occur, in particular if \code{split} has
zero characters, \code{x} is split into single characters.}

\item{...}{Extra arguments are passed to \code{base::strsplit()}.}
}
\value{
A list of the same length as \code{x}, the \eqn{i}-th element of
which contains the vector of splits of \code{x[i]}. ANSI styles are
retained.
}
\description{
This is the color-aware counterpart of \code{\link[base:strsplit]{base::strsplit()}}.
It works almost exactly like the original, but keeps the colors in the
substrings.
}
\examples{
str <- paste0(
  col_red("I am red---"),
  col_green("and I am green-"),
  style_underline("I underlined")
)

cat(str, "\n")

# split at dashes, keep color
cat(ansi_strsplit(str, "[-]+")[[1]], sep = "\n")
strsplit(ansi_strip(str), "[-]+")

# split to characters, keep color
cat(ansi_strsplit(str, "")[[1]], "\n", sep = " ")
strsplit(ansi_strip(str), "")
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_columns}()},
\code{\link{ansi_nchar}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_strwrap}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()},
\code{\link{ansi_toupper}()},
\code{\link{ansi_trimws}()}
}
\concept{ANSI string operations}
