% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_strip}
\alias{ansi_strip}
\title{Remove ANSI escape sequences from a string}
\usage{
ansi_strip(string, sgr = TRUE, csi = TRUE)
}
\arguments{
\item{string}{The input string.}

\item{sgr}{Whether to remove for SGR (styling) control sequences.}

\item{csi}{Whether to remove for non-SGR control sequences.}
}
\value{
The cleaned up string. Note that \code{ansi_strip()} always drops
the \code{ansi_string} class, even if \code{sgr} and sci\code{are}FALSE`.
}
\description{
The input may be of class \code{ansi_string} class, this is also dropped
from the result.
}
\examples{
ansi_strip(col_red("foobar")) == "foobar"
}
\seealso{
Other low level ANSI functions: 
\code{\link{ansi_has_any}()},
\code{\link{ansi_hide_cursor}()},
\code{\link{ansi_regex}()}
}
\concept{low level ANSI functions}
