% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pluralize.R
\name{pluralize}
\alias{pluralize}
\title{String templating with pluralization}
\usage{
pluralize(
  ...,
  .envir = parent.frame(),
  .transformer = glue::identity_transformer
)
}
\arguments{
\item{..., .envir, .transformer}{All arguments are passed to \code{\link[glue:glue]{glue::glue()}}.}
}
\description{
\code{pluralize()} is similar to \code{\link[glue:glue]{glue::glue()}}, with two differences:
\itemize{
\item It supports cli's \link{pluralization} syntax, using \verb{\{?\}} markers.
\item It collapses substituted vectors into a comma separated string.
}
}
\details{
See \link{pluralization} and some examples below.

You need to install the glue package to use this function.
}
\examples{
\dontshow{if (requireNamespace("glue", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Regular plurals
nfile <- 0; pluralize("Found {nfile} file{?s}.")
nfile <- 1; pluralize("Found {nfile} file{?s}.")
nfile <- 2; pluralize("Found {nfile} file{?s}.")

# Irregular plurals
ndir <- 1; pluralize("Found {ndir} director{?y/ies}.")
ndir <- 5; pluralize("Found {ndir} director{?y/ies}.")

# Use 'no' instead of zero
nfile <- 0; pluralize("Found {no(nfile)} file{?s}.")
nfile <- 1; pluralize("Found {no(nfile)} file{?s}.")
nfile <- 2; pluralize("Found {no(nfile)} file{?s}.")

# Use the length of character vectors
pkgs <- "pkg1"
pluralize("Will remove the {pkgs} package{?s}.")
pkgs <- c("pkg1", "pkg2", "pkg3")
pluralize("Will remove the {pkgs} package{?s}.")

pkgs <- character()
pluralize("Will remove {?no/the/the} {pkgs} package{?s}.")
pkgs <- c("pkg1", "pkg2", "pkg3")
pluralize("Will remove {?no/the/the} {pkgs} package{?s}.")

# Multiple quantities
nfiles <- 3; ndirs <- 1
pluralize("Found {nfiles} file{?s} and {ndirs} director{?y/ies}")

# Explicit quantities
nupd <- 3; ntotal <- 10
cli_text("{nupd}/{ntotal} {qty(nupd)} file{?s} {?needs/need} updates")
\dontshow{\}) # examplesIf}
}
\seealso{
Other pluralization: 
\code{\link{no}()},
\code{\link{pluralization}}
}
\concept{pluralization}
