% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive.R
\name{fix.dates}
\alias{fix.dates}
\title{Fix dates}
\usage{
fix.dates(x, max.NA = 0.8, min.obs = nrow(x) * 0.05, locale = "C",
  info = TRUE, use.probs = TRUE)
}
\arguments{
\item{x}{A data.frame}

\item{max.NA}{Maximum allowed proportion of NA values created by coercion}

\item{min.obs}{Minimum number of non-NA observations allowed per variable}

\item{locale}{Locale to be used for month names}

\item{info}{Add generated missing values an excluded variable information as attributes}

\item{use.probs}{Solve ambiguities by similarity to the most frequent formats}
}
\description{
Fixes dates
}
\examples{
mydata<-data.frame(Dates1=c("25/06/1983", "25-08/2014", "2001/11/01", "2008-10-01"),
                   Dates2=c("01/01/85", "04/04/1982", "07/12-2016", NA),
                   Numeric1=rnorm(4))
fix.dates(mydata)
}
