context("meteo-metadata")

m_hs <- meteo_metadata_imgw("hourly", "synop")
m_hc <- meteo_metadata_imgw("hourly", "climate")
m_ds <- meteo_metadata_imgw("daily", "synop")
m_dc <- meteo_metadata_imgw("daily", "climate")
m_dp <- meteo_metadata_imgw("daily", "precip")
m_ms <- meteo_metadata_imgw("monthly", "synop")
m_mc <- meteo_metadata_imgw("monthly", "climate")
m_mp <- meteo_metadata_imgw("monthly", "precip")

test_that("meteo-metadata works!", {
  expect_error(meteo_metadata_imgw("hourly", "precip"))
  expect_equal(dim(m_hs[[1]]), c(107, 3))
  expect_equal(dim(m_hc[[1]]), c(22, 3))
  expect_equal(dim(m_ds[[1]]), c(65, 3))
  expect_equal(dim(m_ds[[2]]), c(23, 3))
  expect_equal(dim(m_dc[[1]]), c(18, 3))
  expect_equal(dim(m_dc[[2]]), c(13, 3))
  expect_equal(dim(m_dp[[1]]), c(16, 3))
  expect_equal(dim(m_ms[[1]]), c(60, 3))
  expect_equal(dim(m_ms[[2]]), c(22, 3))
  expect_equal(dim(m_mc[[1]]), c(27, 3))
  expect_equal(dim(m_mc[[2]]), c(12, 3))
  expect_equal(dim(m_mp[[1]]), c(14, 3))
})
