% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale0to1.R
\name{rescale0to1}
\alias{rescale0to1}
\title{Rescale raster from 0 to 1}
\usage{
rescale0to1(rasterForCalculation)
}
\arguments{
\item{rasterForCalculation}{A raster that contains data to be rescaled}
}
\value{
A raster that has been rescaled from 0 to 1
}
\description{
A function to rescale a raster from 0 to 1. This is done using the formula (value-min)/(max-min).
}
\examples{

data(precipDeviation);
precipStability <- 1/precipDeviation;
relativeClimateStability <- rescale0to1(precipStability);

}
\references{
Owens, HL, and RP Guralnick. Submitted, Biodiversity Informatics.
}
\keyword{manip}
