% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility-formatPlotlyClinData.R
\name{formatPlotlyClinData}
\alias{formatPlotlyClinData}
\title{Format interactive plot, with possibility to download patient profiles
on a click event.}
\usage{
formatPlotlyClinData(
  pl,
  data,
  idVar = "USUBJID",
  pathVar = NULL,
  pathDownload = TRUE,
  idFromDataPlot = FALSE,
  idVarPlot = "key",
  labelVarPlot = NULL,
  highlightOn = "plotly_click",
  highlightOff = "plotly_doubleclick",
  id = paste0("plotClinData", sample.int(n = 1000, size = 1)),
  selectVars = NULL,
  selectLab = getLabelVar(selectVars, labelVars = labelVars),
  keyVar = NULL,
  labelVars = NULL,
  verbose = FALSE
)
}
\arguments{
\item{pl}{\code{plotly} object.}

\item{data}{Data.frame with data.}

\item{idVar}{String with variable of \code{data}
containing plot element.}

\item{pathVar}{String with variable of \code{data} containing path
to a subject-specific report (e.g. patient profiles).}

\item{pathDownload}{Logical, if TRUE (by default) the subject-specific report(s)
are downloaded in a zip compressed file.
If FALSE (only available if unique report per \code{idVarPlot}),
each report is opened in a new window.}

\item{idFromDataPlot}{Logical, if TRUE (by default) \code{idVarPlot}
is extracted from the data of the plot output object (e.g. if this plot
was created from \code{\link[plotly]{ggplotly}}), otherwise
directly from the plot object 
(if the plot was created from \code{\link[plotly]{plot_ly}} directly).}

\item{idVarPlot}{String with variable in the \code{\link[plotly]{plotly}}
output containing IDs.}

\item{labelVarPlot}{String with plotly variable used to
extract label to build the file name of the zip compressed
file containing patient report.
If not specified, the label are extracted based on the \code{idVarPlot}
of the selected plot element.}

\item{highlightOn}{String with event to turn on the selection
(\code{on} parameter of \code{\link[plotly]{highlight}}),
'plotly_click' by default.}

\item{highlightOff}{String with event to turn off the selection
(\code{off} parameter of \code{\link[plotly]{highlight}}),
'plotly_doubleclick' by default.}

\item{id}{String with general id for the plot:
\itemize{
\item{'id' is used as \code{group} for the \code{\link[crosstalk]{SharedData}}}
\item{'button:[id]' is used as button ID if \code{table} is TRUE}
}
If not specified, a random id, as 'plotClinData[X]' is used.}

\item{selectVars}{(optional) Character vector with variable(s) from \code{data}
for which a selection box should be included. This enables to select the data
displayed in the plot (and associated table).}

\item{selectLab}{(Named) character vector with label for \code{selectVars}.}

\item{keyVar}{String with unique key variable, identifying unique
group for which the link between the table and the plot should be done.}

\item{labelVars}{Named character vector containing variable labels.}

\item{verbose}{Logical, if TRUE report progress messages
during execution (included in the browser 'Console').}
}
\value{
Updated \code{\link[plotly]{plotly}} object.
}
\description{
Format interactive plot, with possibility to download patient profiles
on a click event.
}
\author{
Laure Cougnaud
}
