% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility-watermark.R
\name{getWatermark}
\alias{getWatermark}
\title{Get a watermark, to be included in a clinical visualization}
\usage{
getWatermark(
  label = "EXPLORATORY",
  color = "lightgrey",
  fontsize = 20,
  file = NULL,
  width = 800,
  height = 500
)
}
\arguments{
\item{label}{String with label for the watermark, 'EXPLORATORY' by default.}

\item{color}{String with color for the watermark, 'lightgrey' by default.}

\item{fontsize}{Integer with fontsize for the watermark, 20 by default.}

\item{file}{(optional) String with path to a file where the watermark will be
exported to.}

\item{width}{Numeric, width of the plot in pixels,
800 by default.}

\item{height}{Numeric, height of the plot in pixels,
500 by default.}
}
\value{
The \code{file} with the watermark (invisibly).
}
\description{
Get a watermark, to be included in a clinical visualization
}
\examples{
# export a watermark to a file
watermark <- tempfile(pattern = "watermark", fileext = ".png")
getWatermark(file = watermark)
}
\seealso{
Other watermark helpers: 
\code{\link{addWatermark}()}
}
\author{
Laure Cougnaud, Kirsten van Hoorde
}
\concept{watermark helpers}
