% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility-layout.R
\name{layoutClinData}
\alias{layoutClinData}
\title{Set layout for a clinical data plot.}
\usage{
layoutClinData(
  xLab = NULL,
  yLab = NULL,
  title = NULL,
  caption = NULL,
  subtitle = NULL,
  includeLegend = FALSE,
  legendPosition = "right",
  facet = FALSE,
  nrow = 1L,
  ncol = 1L,
  width,
  height,
  watermark = NULL,
  ...
)
}
\arguments{
\item{xLab}{String with label for \code{xVar}.}

\item{yLab}{String with label for \code{xVar}.}

\item{title}{String with title for the plot.}

\item{caption}{String with caption. \cr
The caption is included at the bottom right of the plot.
Please note that this might overlap with 
vertical or rotated x-axis labels.}

\item{subtitle}{String with subtitle.\cr
The subtitle is included at the top left of the plot,
below the title.}

\item{includeLegend}{Logical, if TRUE (by default)
a legend is available in the plot.}

\item{legendPosition}{String with position of the legend,
among: 'top'/'left'/'bottom'/'right', 'right' by default.}

\item{facet}{Logical (FALSE by default), 
does the plot contains facets?}

\item{nrow}{single-length integer specifying the 
number of facet rows in the plot. (default = 1) 
Overwritten if \code{gg} is specified.}

\item{ncol}{single-length integer specifying the 
number of facet columns in the plot. (default = 1)
Overwritten if \code{gg} is specified.}

\item{width}{Numeric, width of the plot in pixels,
800 by default.}

\item{height}{Numeric, height of the plot in pixels,
500 by default.}

\item{watermark}{(optional) String with path to a file containing a watermark.}

\item{...}{Any parameters for the \code{\link[plotly]{layout}}
function. This should contain at least the plot object.}
}
\value{
The updated \code{plotly} object
}
\description{
Set layout for a clinical data plot.
}
\author{
Laure Cougnaud
}
