% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roundHalfUp.R
\name{roundHalfUpTextFormat}
\alias{roundHalfUpTextFormat}
\title{Round a number with 'round-up' strategy for rounding off a 5 in text format}
\usage{
roundHalfUpTextFormat(x, digits = 0)
}
\arguments{
\item{x}{Numeric vector to round.}

\item{digits}{Integer with number of digits to consider, 0 by default.}
}
\value{
A character vector with the rounded number.
NA values are returned as 'NA' as string.
}
\description{
This function rounds numbers with a 'round-up' strategy 
for rounding off a 5. 
The function rounds for a specified number of digits
and format number to a: 'xxx.xxx' text.
}
\details{
The following workflow is used:
\enumerate{
\item{numbers are rounded with the \code{\link{roundHalfUp}}
function, see the \code{? roundHalfUp} for more details
on the rounding strategy}
\item{round numbers are formatted to character in
the format: 'xxx.xxx' with pads leading zeros}
}
}
\examples{
# number of digits higher than number of decimal
roundHalfUpTextFormat(x = c(0.345, 0.567, -0.98), digits = 2)
# number of digits lower than number of decimal
roundHalfUpTextFormat(x = c(0.345, 0.567, -0.98), digits = 0)
# by default, 'digits' is 0!
roundHalfUpTextFormat(x = c(0.345, 0.567, -0.98))
# padding zeros
roundHalfUpTextFormat(1.23, 10)
}
\seealso{
\link{roundHalfUp} for the rounding customization.
}
\author{
Laure Cougnaud and Michela Pasetto
}
