% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cutoff.R
\name{get_cutoff}
\alias{get_cutoff}
\title{Get Used Cutoff And Type From A clinisig Object}
\usage{
get_cutoff(x, with_descriptives = FALSE)
}
\arguments{
\item{x}{A clinisig object}

\item{with_descriptives}{Logical indicating whether you want to retrieve only
the cutoff type and value or the summary statistics on which it is based
on. The default is \code{FALSE}.}
}
\value{
A tibble with cutoff information
}
\description{
Get Used Cutoff And Type From A clinisig Object
}
\examples{
results <- jacobson_1989 \%>\%
  clinical_significance(
    id = subject,
    time = time,
    outcome = gds,
    pre = "pre",
    reliability = 0.80,
    m_functional = 30,
    sd_functional = 10,
    type = "c"
  )

get_cutoff(results)
}
