% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cs_get_model.R
\name{cs_get_model}
\alias{cs_get_model}
\title{Get The HLM Model From A cs_analysis Object}
\usage{
cs_get_model(x)
}
\arguments{
\item{x}{A cs_analysis object}
}
\value{
A model of class \code{lmerMod}
}
\description{
With \code{cs_get_model()} you can extract the fitted HLM model for
the distribution-based approach. This is useful to either diagnose the
model further (beacuse all assumptions of HLMs apply in this case) or plot
the results differently.
}
\examples{
cs_results <- claus_2020 |>
  cs_distribution(id, time, bdi, rci_method = "HLM")

cs_get_model(cs_results)
}
\seealso{
Extractor functions
\code{\link{cs_get_augmented_data}()},
\code{\link{cs_get_data}()},
\code{\link{cs_get_n}()},
\code{\link{cs_get_reliability}()},
\code{\link{cs_get_summary}()}
}
\concept{get}
