% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genotype_probabilities.R
\name{genotype_probabilities}
\alias{genotype_probabilities}
\title{Calculate the genotype probabilities of a target person}
\usage{
genotype_probabilities(target_ID, fam, geno_freq, trans, penet)
}
\arguments{
\item{target_ID}{The individual identifier (\code{indiv}) of the person in
the pedigree \code{fam} whose genotype probabilities are sought.}

\item{fam}{A data frame with rows corresponding to people and columns
corresponding to the following variables (other variables can be included
but will be ignored), which will be coerced to \code{character} type:
\itemize{
\item \code{indiv}, an identifier for each individual person, with no duplicates
in \code{fam}.
\item \code{mother}, the individual identifier of each person's mother, or missing
(\code{NA}) for founders.
\item \code{father}, the individual identifier of each person's father, or missing
(\code{NA}) for founders.
}}

\item{geno_freq}{A vector of strictly positive numbers that sum to \code{1}.
The possible genotypes of the underlying genetic model are
\code{1:length(geno_freq)}, and \code{geno_freq[j]} is interpreted as the population
frequency of genotype \code{j}. For certain genetic models that often
occur in applications, these genotype frequencies can be calculated by
\code{\link{geno_freq_HWE}}.}

\item{trans}{An \code{ngeno^2} by \code{ngeno} matrix of non-negative numbers whose rows
all sum to \code{1}, where \code{ngeno = length(geno_freq)} is the number of possible
genotypes.  The rows of \code{trans} correspond to joint parental
genotypes and the columns to offspring genotypes.
The element \code{trans[ngeno * gm + gf - ngeno, go]} is interpreted as the conditional
probability that a person has genotype \code{go}, given that his or her
biological mother and father have genotypes \code{gm} and \code{gf}, respectively.
For certain genetic models that often occur in applications,
this transmission matrix can be calculated by \code{\link{trans_monogenic}}.}

\item{penet}{An \code{nrow(dat)} by \code{length(geno_freq)} matrix of non-negative
numbers. The element \code{penet[i,j]} is interpreted as the conditional
probability of the phenotypes of the person corresponding to row \code{i} of
\code{fam}, given that his or her genotype is \code{j}.
Note that known genotype data can be incorporated into \code{penet} by regarding
known genotypes as phenotypes, i.e. by regarding known genotypes as
(possibly noisy) measurements of the underlying true genotypes.
If any row of \code{penet} consists entirely of zeroes then the family's
phenotypes are impossible, and \code{-Inf} is returned.}
}
\value{
A vector of length \code{length(geno_freq)} whose \code{j}th element is
the conditional probability that the target person has genotype \code{j},
given the family's relationship structure and phenotypes.
}
\description{
For a given individual within a given family, calculate the person's
conditional genotype probabilities, given the family's phenotypes and
relationship structure
}
\details{
The genotype probabilities are calculated by essentially the same algorithm
as the one that underlies \code{\link{pedigree_loglikelihood}};
see there for details.
}
\examples{
# Read in some sample data
data("dat_small", "penet_small")
str(dat_small)
str(penet_small)

# Calculate the genotype probabilities for individual "ora008" in the family "ora"
w <- which(dat_small$family == "ora")
fam <- dat_small[w, -1]
penet <- penet_small[w, ]
trans <- trans_monogenic(2)
geno_freq <- geno_freq_HWE(p_alleles = c(0.9, 0.1))
genotype_probabilities(target_ID = "ora008", fam, geno_freq, trans, penet)

}
